package cn.xhteam.boot.core;

import cn.xhteam.boot.http.EmptyRequestException;
import cn.xhteam.boot.http.HttpServletRequest;
import cn.xhteam.boot.http.HttpServletResponse;

import java.io.IOException;
import java.net.Socket;
public class ClientHandler implements Runnable {
    private Socket socket;

    public ClientHandler(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void run() {
        try{
            //1.解析请求
            HttpServletRequest request = new HttpServletRequest(socket);
            HttpServletResponse response = new HttpServletResponse(socket);

            //2.处理请求
            DispatcherServlet.getDispatcherServlet().service(request, response);

            //3.发送响应
            response.response();

        } catch (IOException e){
            e.printStackTrace();
        } catch (EmptyRequestException e) {
            //空请求什么都不做，直接断开连接
        } finally {
            //关闭socket
            try {
                socket.close();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}