package cn.xhteam.boot.core;

import cn.xhteam.boot.util.FileClassUtil;
import cn.xhteam.boot.annotation.Controller;
import cn.xhteam.boot.annotation.RequestMapping;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CatBootApplication {
    public static final Logger logger = LogManager.getLogger();
    private ServerSocket serverSocket; //服务套接字
    private ExecutorService threadPool; //线程池
    protected static Class BootClass; //启动类的类对象
    private Properties props; //配置

    public void getPropConfig() {
        try {
            File file = new File(new File(DispatcherServlet.class.getClassLoader().getResource(".").toURI()), "application.properties");
            props = new Properties();
            if (file.exists()) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                props.load(bis);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 构造方法
     */
    public CatBootApplication() {
        try {
            getPropConfig();
            logger.error("start server loadding...");
            String[] banner = {
                    "    /\\_/\\",
                    "   / o o \\",
                    "  (   \"   )",
                    "   \\~(*)~/",
                    "    - ^ -",
                    "BBBBB  OOOOO  OOOOO  TTTTTTT",
                    "B    B O    O O    O    T   ",
                    "BBBBB  O    O O    O    T   ",
                    "B    B O    O O    O    T   ",
                    "BBBBB  OOOOO  OOOOO     T   "
            };

            for (String line : banner) {
                System.out.println(line);
            }
            String prot = props.getProperty("server.prot", "8080");
            serverSocket = new ServerSocket(Integer.valueOf(prot));
            String threadPool = props.getProperty("server.thread.pool", String.valueOf(100));
            Executors.newFixedThreadPool(Integer.parseInt(threadPool));
            init();
            logger.error("start server sucess!\tthread pool:" + threadPool + " \taddress：http://" + InetAddress.getLocalHost().getHostAddress() + ":" + prot);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void init() {
        try {
            List<Class<?>> classObjs = scanControllers();
            for (Class<?> classObj : classObjs) {
                Controller controller = classObj.getAnnotation(Controller.class);
                String cv = controller.value();
                Method[] methods = classObj.getDeclaredMethods();
                logger.error("扫描controller类加载器：" + classObj.getName() + "\tmethods count --->\t" + methods.length);
                for (Method method : methods) {
                    if (method.isAnnotationPresent(RequestMapping.class)) {
                        RequestMapping rm = method.getAnnotation(RequestMapping.class);
                        String value = rm.value();
                        if (null != cv) {
                            value = cv + value;
                        }
                        HandMapping.putMethod(value, method);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<Class<?>> scanControllers() {
        List<Class<?>> list = FileClassUtil.getClasses(CatBootApplication.BootClass.getPackage().getName());
        Iterator<Class<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Class<?> cls = iterator.next();
            if (!cls.isAnnotationPresent(Controller.class)) {
                iterator.remove();
            }
        }
        return list;
    }

    public void start() {
        try {
            while (true) {
                Socket socket = serverSocket.accept();
                //使用线程池处理与该客户端的交互
                ClientHandler handler = new ClientHandler(socket);
                threadPool.execute(handler);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 主程序
     *
     * @param args
     */
    public static void run(Class cls, String[] args) {
        BootClass = cls;
        CatBootApplication application = new CatBootApplication();
        application.start();
    }
}
