package cn.xhteam.boot.core.util;

import com.github.houbb.asm.tool.reflection.AsmMethods;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class BootUtil {
    public static String lowerFirst(String str) {
        // 同理
        char[] cs = str.toCharArray();
        cs[0] += 32;
        return String.valueOf(cs);
    }

    public static List<String> travelRootWithResult(Object object) {
        List<String> resultList = new ArrayList<>();
        if (object instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap) object;
            Set<Object> keySet = map.keySet();
            for (Object key : keySet) {
                List<String> keyList = new ArrayList<>();
                keyList.add((String) key);
                travelTreeNode(map.get(key), keyList, resultList);
            }
        }
        return resultList;
    }


    public static void travelTreeNode(Object obj, List<String> keyList, List<String> resultList) {
        if (obj instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap) obj;
            linkedHashMap.forEach((key, value) -> {
                if (value instanceof LinkedHashMap) {
                    keyList.add((String) key);
                    travelTreeNode(value, keyList, resultList);
                    keyList.remove(keyList.size() - 1);
                } else {
                    StringBuilder result = new StringBuilder();
                    for (String strKey : keyList) {
                        result.append(strKey).append(".");
                    }
                    result.append(key).append("=").append(value);
                    resultList.add(result.toString());
                }
            });
        } else {
            StringBuilder result = new StringBuilder();
            result.append(keyList.get(0)).append("=").append(obj);
            resultList.add(result.toString());
        }
    }


    public static boolean isOrdinaryType(Class<?> cls) {
        System.out.println(cls.getTypeName());
        if (cls.getTypeName().equals("java.lang.String")) {
            return true;
        }if (cls.getTypeName().equals("java.lang.Integer")) {
            return true;
        }
        return false;
    }

    public static boolean validParam(Parameter[] parameters) {
        boolean isTo  = true;
        if(parameters.length > 0){
          isTo = isOrdinaryType(parameters[0].getType());
            for (Parameter parameter : parameters) {
                if(isTo != isOrdinaryType(parameter.getType())){
                    throw new RuntimeException("接口参数类型不合规");
                }
            }
        }
        return isTo;
    }
    public static Object[] getMethodParamsObj(Parameter[] parameters) {
        Object[] param = new Object[parameters.length];
        for (int i = 0; i < parameters.length; i++) {
            param[i]=parameters[i];
        }
        return param;
    }
    public static String[] getMethodParams(Method method) {
        String[] paramName = new String[method.getParameterCount()];
        List<String> paramNames = AsmMethods.getParamNamesByAsm(method);
        for (int i = 0; i < paramNames.size(); i++) {
            paramName[i] = paramNames.get(i);
            if (i == method.getParameterCount() - 1) {
                break;
            }
        }
        return paramName;
    }
}
