package cn.xhteam.boot.web.util;

import cn.xhteam.boot.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.github.houbb.asm.tool.reflection.AsmMethods;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.*;

public class BootUtil {
    public static String lowerFirst(String str) {
        // 同理
        char[] cs = str.toCharArray();
        cs[0] += 32;
        return String.valueOf(cs);
    }

    public static boolean isOrdinaryType(Class<?> cls) {
        List<String> type = Arrays.asList("int", "char", "double", "boolean", "float", "String", "Integer", "Boolean", "Double", "Float");
        return type.contains(cls.getSimpleName());
    }

    public static boolean isParameterTypeObject(Parameter[] parameters) {
        for (Parameter parameter : parameters) {
            if (!isOrdinaryType(parameter.getType())) {
                return true;
            }
        }
        return false;
    }


    //验证参数是否合法
    public static boolean validBaseParam(Parameter[] parameters) {
        boolean isTo = false;
        if (parameters.length > 0) {
            if (!isOrdinaryType(parameters[0].getType())) {
                return false;
            }
            for (Parameter parameter : parameters) {
                if (isTo != isOrdinaryType(parameter.getType())) {
                    throw new RuntimeException("接口参数类型不合规");
                }
            }
        }
        return isTo;
    }

    public static Object[] setBaseParam(Map<String, String[]> mapParam, String[] paramNames, Parameter[] parameters) {
        Object[] paramObj = new Object[paramNames.length];
        for (int i = 0; i < mapParam.keySet().size(); i++) {
            String args = mapParam.get(paramNames[i])[0];
            paramObj[i] = cast(args, parameters[i].getType());
        }
        return paramObj;
    }

    public static Object cast(String val, Class<?> cls) {
        String simpleName = cls.getSimpleName();
        switch (simpleName) {
            case "Integer":
                return Integer.valueOf(val);
            case "Long":
                return Long.valueOf(val);
            case "Boolean":
                return Boolean.valueOf(val);
            case "Float":
                return Float.valueOf(val);
            case "Double":
                return Double.valueOf(val);
        }
        return cls.cast(val);
    }

    //根据类型设置参数
    public static Object setObjModel(Map<String, String[]> mapParam, Class<?> cls) {
        Object paramObj = null;
        try {
            Object o = cls.newInstance();
            for (String key : mapParam.keySet()) {
                Field field = null;
                try {
                    field = cls.getDeclaredField(key);
                } catch (Exception ignored) {
                }//拦截异常
                if (field != null) {
                    field.setAccessible(true);
                    field.set(o, cast(mapParam.get(key)[0], field.getType()));
                }
            }
            paramObj = o;
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return paramObj;
    }


    public static Object setMethodParamByBody(String body, Parameter[] parameters) {
        Object paramObj = null;
        if (parameters.length > 1) {//对象超过1个参数
            throw new RuntimeException("接口参数对象个数不合法");
        }
        if (JSON.isValidArray(body)) {//验证是否是数组
            Class<?> entityClass = (Class<?>) ((ParameterizedType) parameters[0].getParameterizedType()).getActualTypeArguments()[0];
            List<Object> list = new ArrayList<>();
            JSONArray array = JSON.parseArray(body);
            for (int i = 0; i < array.size(); i++) {
                Map<String, Object> map = JSON.parseObject(array.getJSONObject(i).toJSONString());
                Map<String, String[]> mapParam = new HashMap<>();
                for (String s : map.keySet()) {
                    mapParam.put(s, new String[]{map.get(s).toString()});
                }
                list.add(setObjModel(mapParam, entityClass));
            }
            paramObj = list;
        } else {
            Map<String, Object> map = JSON.parseObject(body);
            Map<String, String[]> mapParam = new HashMap<>();
            for (String s : map.keySet()) {
                mapParam.put(s, new String[]{map.get(s).toString()});
            }
            paramObj = setObjModel(mapParam, parameters[0].getType());
        }
        return paramObj;
    }

    public static Object[] getMethodParamsObj(Map<String, String[]> mapParam, Parameter[] parameters) {
        if (ObjectUtil.isNull(parameters) || parameters.length == 0) {
            return null;
        }
        if (parameters.length > 1) {//对象超过1个参数
            throw new RuntimeException("参数对象存在多个不合法");
        }
        if ("List".equals(parameters[0].getType().getSimpleName())) {
            throw new RuntimeException("GET请求参数不能为集合");
        }
        Parameter parameter = parameters[0];
        Object object = setObjModel(mapParam, parameter.getType());
        return new Object[]{object};
    }

    public static String[] getMethodParams(Method method) {
        String[] paramName = new String[method.getParameterCount()];
        List<String> paramNames = AsmMethods.getParamNamesByAsm(method);
        for (int i = 0; i < paramNames.size(); i++) {
            paramName[i] = paramNames.get(i);
            if (i == method.getParameterCount() - 1) {
                break;
            }
        }
        return paramName;
    }
}
