//package cn.xhteam.boot.web.load;
//
//import cn.xhteam.boot.core.bean.HandContainer;
//import cn.xhteam.boot.core.bean.LoadClassBean;
//import cn.xhteam.boot.core.stereotype.*;
//import cn.xhteam.boot.core.util.FileClassUtil;
//import cn.xhteam.boot.web.interceptor.WebMvcConfigure;
//import com.alibaba.fastjson2.JSON;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.lang.reflect.Field;
//import java.lang.reflect.InvocationTargetException;
//import java.lang.reflect.Method;
//import java.lang.reflect.Parameter;
//import java.util.*;
//import java.util.concurrent.ConcurrentHashMap;
//import java.util.stream.Collectors;
//
//public class LoadClassHand1 {
//    public static final Logger logger = LoggerFactory.getLogger(LoadClassHand1.class);
//
//    public static void init(Class bootClass) {
//        try {
//            List<Class<?>> list = new ArrayList<>();
//            if (null != bootClass.getPackage()) {
//                list = FileClassUtil.getClasses(bootClass.getPackage().getName());//扫描外部的类
//            }
////            list.addAll(FileClassUtil.getClasses("cn.xhteam.boot"));//扫描本部的类
//            loadControllers(list);//扫描控制器
////            loadBean(list);//扫描Service
////            autoAwareBean();
//            loadBeanContainer(list);// 扫描加载 Bean容器
//            autoConfigure();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static void loadControllers(List<Class<?>> list) throws IllegalAccessException, InstantiationException {
//        for (Class<?> classObj : list) {
//            if (!classObj.isAnnotationPresent(Controller.class)) {
//                continue;
//            }
//            Controller controller = classObj.getAnnotation(Controller.class);
//            String cv = controller.value();
//            Method[] methods = classObj.getDeclaredMethods();
//            logger.info("find controller loader：" + classObj.getTypeName() + "\taction num:\t" + methods.length);
//            HandContainer.putBeanMap(classObj.getTypeName(), classObj.newInstance());
//            for (Method method : methods) {
//                if (!method.isAnnotationPresent(RequestMapping.class)) {
//                    continue;
//                }
//                RequestMapping rm = method.getAnnotation(RequestMapping.class);
//                String value = rm.value();
//                if (null != cv) {
//                    value = cv + value;
//                }
//                HandContainer.putMethod(value, method);
//            }
//
//        }
//    }
//
//    //先循环遍历所有的@service注解，在判断此类下的Autowite的属性是否为空，如果为空就跳下个Class进来注入，直到保证全部不为空就new注入容器 ，否则一直下一个。
//    private static void loadBean(List<Class<?>> list) {
//        try {
//            Iterator<Class<?>> iterator = new ArrayList<>(list).iterator();
//            List<Class<?>> notList = new ArrayList<>();
//            while (iterator.hasNext()) {
//                Class<?> cls = iterator.next();
//                if (!cls.isAnnotationPresent(Service.class) && !cls.isAnnotationPresent(Controller.class) && !cls.isAnnotationPresent(Configuration.class)) {
//                    iterator.remove();
//                    continue;
//                }
//                Object newClass = cls.newInstance();
//                //判断类下面的Autowired是否全部注解完成，注册完成则放入容器
//                Field[] fields = cls.getDeclaredFields();
//                boolean joinBean = true;//是否加入bean
//                for (Field field : fields) {
//                    if (!field.isAnnotationPresent(Autowired.class)) {//判断变量是否是容器bean
//                        continue;
//                    }
//                    //当属性在容器里面找不到，就跳过此Class，到下一次在找
//                    if (!HandContainer.containsKey(field.getType().getTypeName())) {
//                        notList.add(cls);
//                        joinBean = false;
//                        break;
//                    }
//                    field.setAccessible(true);
//                    field.set(newClass, HandContainer.getBeanMap(field.getType().getTypeName()));
//                }
//                if (cls.isAnnotationPresent(Configuration.class)) {
//                    HandContainer.addConfigurationList(cls.getTypeName());
//                }
//                if (joinBean) {
//                    //判断这个接口实现了多少接口，全部都注入进去
//                    Class<?>[] interfaces = cls.getInterfaces();
//                    HandContainer.putBeanMap(cls.getTypeName(), newClass);
//                    for (Class<?> item : interfaces) {
//                        HandContainer.putBeanMap(item.getTypeName(), newClass);
//                    }
//                }
//            }
//            if (notList.size() > 0) {
//                loadBean(notList);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//
//    private static void loadBeanContainer(List<Class<?>> list) {
//        try {
//            Iterator<Class<?>> iterator = new ArrayList<>(list).iterator();
//            List<LoadClassBean> loadList = new ArrayList<>();
//            while (iterator.hasNext()) {
//                Class<?> cls = iterator.next();
//                if (!cls.isAnnotationPresent(Service.class) && !cls.isAnnotationPresent(Controller.class) && !cls.isAnnotationPresent(Configuration.class)) {
//                    iterator.remove();
//                    continue;
//                }
//                if (cls.isAnnotationPresent(Configuration.class)) {
//                    Method[] method = cls.getMethods();
//                    for (Method m : method) {
//                        if (!m.isAnnotationPresent(Bean.class)) {
//                            continue;
//                        }
//
//                        Class<?> bCls = m.getReturnType();
//                        loadList.add(LoadClassBean.getInstance().setType(1).setCurrCls(bCls).setParentCls(cls));
//                    }
//                    logger.info("find configuration loader：" + cls.getTypeName());
//                    HandContainer.addConfigurationList(cls.getTypeName());
//                }
//                loadList.add(LoadClassBean.getInstance().setType(0).setCurrCls(cls));
//            }
//
//            Iterator<LoadClassBean> loadIter = loadList.iterator();
//            while (loadIter.hasNext()) {
//                LoadClassBean bean = loadIter.next();
//                loadBean(loadList, new LinkedList<>(), bean.getCurrCls());
//                loadIter = loadList.iterator();
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static void loadBean(List<LoadClassBean> beanList, LinkedList<String> linkBeans, Class<?> cls) throws IllegalAccessException, InstantiationException, InvocationTargetException {
//        if (linkBeans.contains(cls.getTypeName())) {
//            linkBeans.add(cls.getTypeName());
//            throw new RuntimeException("循环依赖：" + JSON.toJSONString(linkBeans));
//        }
//
//        Iterator<LoadClassBean> loadIter = beanList.iterator();
//
//        LoadClassBean clsBean = null;
//        while (loadIter.hasNext()) {
//            LoadClassBean bean = loadIter.next();
//
//            if (Objects.equals(cls.getTypeName(), bean.getCurrCls().getTypeName())) {
//                clsBean = bean;
//                loadIter.remove();
//                break;
//            }
//
//            boolean find = false;
//            Class<?>[] interfaces = bean.getCurrCls().getInterfaces();
//            for (Class<?> item : interfaces) {
//                if (Objects.equals(cls.getTypeName(), item.getTypeName())) {
//                    clsBean = bean;
//
//                    find = true;
//                    break;
//                }
//            }
//            if (find) {
//                loadIter.remove();
//                break;
//            }
//        }
//
//        if (null == clsBean) {
//            throw new RuntimeException("依赖不存在：" + cls.getTypeName());
//        }
//
//        Class<?> currCls = clsBean.getCurrCls();
//        if (clsBean.getType() == 0) {
//            // load annotation
//            Object clsInst = currCls.newInstance();
//            Field[] fields = currCls.getDeclaredFields();
//            for (Field field : fields) {
//                if (!field.isAnnotationPresent(Autowired.class)) {//判断变量是否是容器bean
//                    continue;
//                }
//                //当属性在容器里面找不到，去加载
//                if (!HandContainer.containsKey(field.getType().getTypeName())) {
//                    LinkedList<String> newLink = new LinkedList<>(linkBeans);
//
//                    newLink.add(cls.getTypeName());
//                    loadBean(beanList, newLink, field.getType());
//                }
//                field.setAccessible(true);
//                field.set(clsInst, HandContainer.getBeanMap(field.getType().getTypeName()));
//            }
//            logger.info("find bean loader：" + currCls.getTypeName());
//            HandContainer.putBeanMap(currCls.getTypeName(), clsInst);
//            Class<?>[] interfaces = currCls.getInterfaces();
//            for (Class<?> item : interfaces) {
//                logger.info("find bean loader：" + item.getTypeName());
//                HandContainer.putBeanMap(item.getTypeName(), clsInst);
//            }
//        } else if (clsBean.getType() == 1) {
//            // load configuration Bean
//            String typeName = clsBean.getParentCls().getTypeName();
//            if (!HandContainer.containsKey(clsBean.getParentCls().getTypeName())) {
//                LinkedList<String> newLink = new LinkedList<>(linkBeans);
//
//                newLink.add(cls.getTypeName());
//                loadBean(beanList, newLink, clsBean.getParentCls());
//            }
//
//            Object parent = HandContainer.getBeanMap(typeName);
//
//            Method[] methods = clsBean.getParentCls().getMethods();
//            Method method = null;
//            for (Method m : methods) {
//                if (!m.isAnnotationPresent(Bean.class)) {
//                    continue;
//                }
//
//                Class<?> rCls = m.getReturnType();
//                if (Objects.equals(currCls.getTypeName(), rCls.getTypeName())) {
//                    method = m;
//                    break;
//                }
//            }
//
//            if (null == method) {
//                throw new RuntimeException("load bean error");
//            }
//
//            Parameter[] parameters = method.getParameters();
//            if (parameters.length > 0) {
//                Object[] objects = new Object[parameters.length];
//                for (int i = 0; i < parameters.length; i++) {
//                    if (!HandContainer.containsKey(parameters[i].getType().getTypeName())) {
//                        LinkedList<String> newLink = new LinkedList<>(linkBeans);
//
//                        newLink.add(cls.getTypeName());
//                        loadBean(beanList, newLink, parameters[i].getType());
//                    }
//                    objects[i] = HandContainer.getBeanMap(parameters[i].getType().getTypeName());
//                }
//                Object clsInst = method.invoke(parent, objects);
//                logger.info("find bean loader：" + currCls.getTypeName());
//                HandContainer.putBeanMap(currCls.getTypeName(), clsInst);
//                Class<?>[] interfaces = currCls.getInterfaces();
//                for (Class<?> item : interfaces) {
//                    logger.info("find bean loader：" + item.getTypeName());
//                    HandContainer.putBeanMap(item.getTypeName(), clsInst);
//                }
//            } else {
//                Object clsInst = method.invoke(parent);
//                HandContainer.putBeanMap(currCls.getTypeName(), clsInst);
//                Class<?>[] interfaces = currCls.getInterfaces();
//                for (Class<?> item : interfaces) {
//                    logger.info("find bean loader：" + item.getTypeName());
//                    HandContainer.putBeanMap(item.getTypeName(), clsInst);
//                }
//            }
//        }
//
//    }
//
//    //调用bean
//    private static void autoAwareBean() {
//        try {
//            Set<String> list = HandContainer.getConfigurationList();
//            for (String s : list) {
//                Object obj = HandContainer.getBeanMap(s);
//                Class<?> cls = obj.getClass();
//                Method[] method = cls.getMethods();
//                for (Method m : method) {
//                    if (!m.isAnnotationPresent(Bean.class)) {
//                        continue;
//                    }
//                    Object bean;
//                    Parameter[] parameters = m.getParameters();
//                    if (parameters.length > 0) {
//                        Object[] param = getConfigurationParam(parameters);
//                        bean = m.invoke(obj, param);
//                    } else {
//                        bean = m.invoke(obj);
//                    }
//                    HandContainer.putBeanMap(bean.getClass().getTypeName(), bean);
//                }
//            }
//        } catch (InvocationTargetException | IllegalAccessException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    private static void autoConfigure() {
//        try {
//            ConcurrentHashMap<String, Object> map = HandContainer.getAll();
//            System.out.println(map);
//            Set<String> list = HandContainer.getConfigurationList();
//            for (String s : list) {
//                Object obj = HandContainer.getBeanMap(s);
//                Class<?> cls = obj.getClass();
//                Method[] configurationMethod = cls.getMethods();
//                if (obj instanceof WebMvcConfigure) {
//                    Method[] methods = WebMvcConfigure.class.getMethods();
//                    for (Method method : configurationMethod) {
//                        Parameter[] instanceParam = method.getParameters();
//                        List<Method> methodList = Arrays.stream(methods).filter(row -> {
//                            Parameter[] interfaceParam = row.getParameters();
//                            if (!Objects.equals(method.getName(), row.getName()) || instanceParam.length != interfaceParam.length) {
//                                return false;
//                            }
//                            int length = instanceParam.length;
//                            for (int i = 0; i < length; i++) {
//                                if (!Objects.equals(instanceParam[i].getType().getTypeName(), interfaceParam[i].getType().getTypeName())) {
//                                    return false;
//                                }
//                            }
//                            return true;
//                        }).collect(Collectors.toList());
//                        if (methodList.size() > 0) {
//                            if (instanceParam.length > 0) {
//                                Object[] param = getConfigurationParam(instanceParam);
//                                method.invoke(obj, param);
//                            } else {
//                                method.invoke(obj);
//                            }
//                        }
//                    }
//                }
//
//            }
//        } catch (InvocationTargetException | IllegalAccessException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//
//    public static Object[] getConfigurationParam(Parameter[] instanceParam) {
//        Object[] objects = new Object[instanceParam.length];
//        for (int i = 0; i < instanceParam.length; i++) {
//            objects[i] = HandContainer.getBeanMap(instanceParam[i].getType().getTypeName());
//        }
//        return objects;
//    }
//
//}
