package cn.xhteam.boot.web.core;

import cn.xhteam.boot.core.bean.HandContainer;
import cn.xhteam.boot.core.enums.HttpMethod;
import cn.xhteam.boot.core.util.Constant;
import cn.xhteam.boot.web.interceptor.HandlerExecutionChain;
import cn.xhteam.boot.web.interceptor.HandlerMapping;
import cn.xhteam.boot.web.server.FrameworkServlet;
import cn.xhteam.boot.web.util.BootUtil;
import cn.xhteam.boot.web.util.ServletUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DispatcherServlet extends FrameworkServlet {
    private static List<HandlerMapping> handlerMappings;

    public DispatcherServlet() {
//        List<HandlerInterceptor> list = new ArrayList<>();
//        list.add(new MyInterceptor());
//        handlerMappings = new ArrayList<>();
//        handlerMappings.add(request -> new HandlerExecutionChain("new", list));
    }


    public static Map<String, Object> getParamMap(HttpServletRequest request) {
        Map<String, Object> params = new HashMap<>();
        BufferedReader br;
        try {
            br = request.getReader();
            String str;
            StringBuilder wholeParams = new StringBuilder();
            while ((str = br.readLine()) != null) {
                wholeParams.append(str);
            }
            if (null != wholeParams.toString()) {
                params = JSON.parseObject(wholeParams.toString(), Map.class);
            }
        } catch (IOException e) {
        }
        return params;
    }

    public static File getFileParam(HttpServletRequest request, Method method) {
        try {
            Map parameters = request.getParameterMap();
            for (Object o : parameters.keySet()) {
                System.out.println(o);
            }
            String[] paramNames = BootUtil.getMethodParams(method);

        } catch (Exception e) {

        }
        return null;
    }

    public String getRequestBody(ServletInputStream ris) throws IOException {
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        int lens;
        while ((lens = ris.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        return content.toString();// 内容
    }


    public Object[] getRequestParam(HttpServletRequest request, Method method) throws IOException {
        if (method.getParameterCount() == 0) {
            return null;
        }
        Object[] objects = new Object[method.getParameterCount()];
        Parameter[] parameters = method.getParameters();
        if (HttpMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
            if (BootUtil.isParameterTypeObject(parameters)) { //验证参数是否为基础数据类型 true 对象类型，false 基本类型
                objects = BootUtil.getMethodParamsObj(request.getParameterMap(), parameters);
            } else {
                objects = BootUtil.setBaseParam(request.getParameterMap(), BootUtil.getMethodParams(method), parameters);
            }
        }
        if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            String body = getRequestBody(request.getInputStream());
            objects[0] = BootUtil.setMethodParamByBody(body, parameters);
        }
        return objects;
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) {
        if (handlerMappings != null) {
            for (HandlerMapping mapping : handlerMappings) {
                HandlerExecutionChain handler = mapping.getHandler(request);
                if (handler != null) {
                    return handler;
                }
            }
        }

        return null;
    }

    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getRequestURI();
//        try {
//            HandlerExecutionChain mappedHandler = this.getHandler(request);
//            if (null != mappedHandler) {
//                if (!mappedHandler.applyPreHandle(request, response)) {
//                    return;
//                }
//                mappedHandler.applyPostHandle(request, response);
//            }
//        } catch (IOException e) {
//            throw new RuntimeException(e);
//        }
        PrintWriter out = null;
        response.setContentType(Constant.CONTENT_TEXT_HTML);
        try {
            out = response.getWriter();
            Method method = HandContainer.getMethod(request.getMethod() + Constant.textLine + path);
            if (method != null) {
                Object[] args = getRequestParam(request, method);
                String beanName = method.getDeclaringClass().getTypeName();
                Object bean = HandContainer.getBeanMap(beanName);
                Object object = null == args || args.length == 0 ? method.invoke(bean) : method.invoke(bean, args);
                String json = JSON.toJSONString(object, JSONWriter.Feature.WriteMapNullValue);
                ServletUtils.renderStr(response, json);
            } else {
                String html = this.RESPONSE_INDEX_HTML;
                if (!"/".equals(path)) {
                    html = Constant.RESPONSE_404_HTML_EN;
                    response.setStatus(404);
                }
                out.write(html);
            }
        } catch (Exception e) {
            e.printStackTrace();
            assert out != null;
            response.setContentType(Constant.CONTENT_APPLICATION_JSON);
            response.setStatus(500);
            out.write(e.getMessage());
        }

    }


    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) {
        this.doDispatch(request, response);
    }
}
