/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.rta;

import cn.xfyun.model.response.rtasr.RtasrResponse;
import cn.xfyun.service.iat.AbstractIatWebSocketListener;
import com.google.gson.Gson;
import java.io.EOFException;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRtasrWebSocketListener
extends WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractIatWebSocketListener.class);
    private static final String STARTED = "started";
    private static final String RESULT = "result";
    private static final String ERROR = "error";

    public abstract void onSuccess(WebSocket var1, String var2);

    public abstract void onFail(WebSocket var1, Throwable var2, @Nullable Response var3);

    public abstract void onBusinessFail(WebSocket var1, String var2);

    public abstract void onClosed();

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
    }

    public void onMessage(WebSocket webSocket, String text) {
        Gson gson = new Gson();
        RtasrResponse rtasrResponse = (RtasrResponse)gson.fromJson(text, RtasrResponse.class);
        String action = rtasrResponse.getAction();
        if (Objects.equals(STARTED, action)) {
            logger.debug("\u670d\u52a1\u7aef\u63e1\u624b\u6210\u529f info : [{}]", (Object)text);
        } else if (Objects.equals(RESULT, action)) {
            this.onSuccess(webSocket, text);
        } else if (Objects.equals(ERROR, action)) {
            this.onBusinessFail(webSocket, text);
            logger.error("\u51fa\u73b0\u9519\u8bef error : [{}]", (Object)text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
        logger.warn("webSocket is closed ,code is {} , reason is [{}]", (Object)code, (Object)reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        logger.warn("webSocket is closed ,code is {} , reason is [{}]", (Object)code, (Object)reason);
        this.onClosed();
    }

    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        if (t instanceof EOFException) {
            this.onClosed();
        } else {
            t.printStackTrace();
            this.onFail(webSocket, t, response);
        }
        if (response != null) {
            response.close();
        }
    }
}

