/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.ise;

import cn.xfyun.api.IseClient;
import cn.xfyun.model.request.ise.IseBusiness;
import cn.xfyun.model.request.ise.IseRequest;
import cn.xfyun.model.request.ise.IseRequestData;
import cn.xfyun.service.common.AbstractTimedTask;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.util.Base64;

public class IseSendTask
extends AbstractTimedTask {
    private static final int STATUS_PREPARE_FRAME = -1;
    private static final int STATUS_FIRST_FRAME = 0;
    private static final int STATUS_CONTINUED_FRAME = 1;
    private static final int STATUS_LAST_FRAME = 2;
    private int status = -1;
    private IseClient iseClient = null;
    static final Base64.Encoder ENCODER = Base64.getEncoder();

    @Override
    public String businessDataProcess(byte[] contents, boolean isEnd) throws InterruptedException {
        if (isEnd) {
            this.status = 2;
        }
        IseBusiness business = new IseBusiness(this.getIseClient());
        switch (this.status) {
            case -1: {
                IseRequest prepareFrame = new IseRequest();
                JsonObject common = new JsonObject();
                common.addProperty("app_id", this.getIseClient().getAppId());
                business.setCmd("ssb");
                business.setAus(null);
                IseRequestData prepareData = new IseRequestData();
                prepareData.setStatus(0);
                prepareData.setData(null);
                prepareFrame.setCommon(common);
                prepareFrame.setBusiness(business);
                prepareFrame.setData(prepareData);
                this.getIseClient().getWebSocket().send(StringUtils.gson.toJson((Object)prepareFrame));
                Thread.sleep(40L);
                this.status = 1;
                prepareFrame.setCommon(null);
                prepareData.setStatus(this.status);
                prepareData.setData(ENCODER.encodeToString(contents));
                business.setCmd("auw");
                business.setAus(1);
                prepareFrame.setBusiness(business);
                return StringUtils.gson.toJson((Object)prepareFrame);
            }
            case 1: {
                IseRequest continueFrame = new IseRequest();
                IseBusiness continueBusiness = new IseBusiness();
                if (!business.isTtp_skip()) {
                    continueBusiness.setCmd("ttp");
                } else {
                    continueBusiness.setCmd("auw");
                }
                continueBusiness.setAus(2);
                continueFrame.setBusiness(continueBusiness);
                IseRequestData continueDate = new IseRequestData();
                continueDate.setStatus(1);
                continueDate.setData(ENCODER.encodeToString(contents));
                continueFrame.setData(continueDate);
                return StringUtils.gson.toJson((Object)continueFrame);
            }
            case 2: {
                IseRequest lastFrame = new IseRequest();
                IseBusiness lastBusiness = new IseBusiness();
                if (!business.isTtp_skip()) {
                    lastBusiness.setCmd("ttp");
                } else {
                    lastBusiness.setCmd("auw");
                }
                lastBusiness.setAus(4);
                lastFrame.setBusiness(lastBusiness);
                IseRequestData lastData = new IseRequestData();
                lastData.setStatus(2);
                lastData.setData("");
                lastFrame.setData(lastData);
                return StringUtils.gson.toJson((Object)lastFrame);
            }
        }
        return null;
    }

    private IseClient getIseClient() {
        if (this.iseClient == null) {
            this.iseClient = (IseClient)this.webSocketClient;
            return this.iseClient;
        }
        return this.iseClient;
    }
}

