/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.igr;

import cn.xfyun.api.IgrClient;
import cn.xfyun.model.request.igr.IgrRequest;
import cn.xfyun.service.common.AbstractTimedTask;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.util.Base64;
import java.util.Objects;

public class IgrSendTask
extends AbstractTimedTask {
    private static final int STATUS_FIRST_FRAME = 0;
    private static final int STATUS_CONTINUED_FRAME = 1;
    private static final int STATUS_LAST_FRAME = 2;
    private int status = 0;
    private IgrClient igrClient = null;
    static final Base64.Encoder ENCODER = Base64.getEncoder();

    @Override
    public AbstractTimedTask build(AbstractTimedTask.Builder builder) {
        return super.build(builder);
    }

    @Override
    public void run() {
        super.run();
    }

    @Override
    public String businessDataProcess(byte[] contents, boolean isEnd) throws InterruptedException {
        if (isEnd) {
            this.status = 2;
        }
        this.igrClient = this.getIgrClient();
        JsonObject data = new JsonObject();
        switch (this.status) {
            case 0: {
                IgrRequest firstFrame = new IgrRequest();
                JsonObject common = new JsonObject();
                common.addProperty("app_id", this.igrClient.getAppId());
                JsonObject business = new JsonObject();
                business.addProperty("ent", this.igrClient.getEnt());
                business.addProperty("aue", this.igrClient.getAue());
                business.addProperty("rate", (Number)this.igrClient.getRate());
                data.addProperty("status", (Number)0);
                data.addProperty("audio", ENCODER.encodeToString(contents));
                firstFrame.setCommon(common);
                firstFrame.setBusiness(business);
                firstFrame.setData(data);
                this.status = 1;
                return StringUtils.gson.toJson((Object)firstFrame);
            }
            case 1: {
                IgrRequest continueFrame = new IgrRequest();
                data.addProperty("status", (Number)1);
                data.addProperty("audio", ENCODER.encodeToString(contents));
                continueFrame.setData(data);
                return StringUtils.gson.toJson((Object)continueFrame);
            }
            case 2: {
                IgrRequest lastFrame = new IgrRequest();
                data.addProperty("status", (Number)2);
                if (Objects.isNull(contents)) {
                    data.addProperty("audio", "");
                } else {
                    data.addProperty("audio", ENCODER.encodeToString(contents));
                }
                lastFrame.setData(data);
                return StringUtils.gson.toJson((Object)lastFrame);
            }
        }
        return null;
    }

    private IgrClient getIgrClient() {
        if (this.igrClient == null) {
            this.igrClient = (IgrClient)this.webSocketClient;
            return this.igrClient;
        }
        return this.igrClient;
    }
}

