/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.igr;

import cn.xfyun.model.response.igr.IgrResponseData;
import com.google.gson.Gson;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIgrWebSocketListener
extends WebSocketListener {
    public static final Gson JSON = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(AbstractIgrWebSocketListener.class);

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        IgrResponseData resp = (IgrResponseData)JSON.fromJson(text, IgrResponseData.class);
        if (resp != null) {
            if (resp.getCode() != 0) {
                logger.error("errorCode:{},  errorMessage:{}, sid:{}, \u9519\u8bef\u7801\u67e5\u8be2\u94fe\u63a5\uff1ahttps://www.xfyun.cn/document/error-code", new Object[]{resp.getCode(), resp.getMessage(), resp.getSid()});
                return;
            }
            if (resp.getData() != null && resp.getData().get("status").getAsInt() == 2) {
                this.onSuccess(webSocket, resp);
                webSocket.close(1000, "");
            }
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        super.onFailure(webSocket, t, response);
        this.onFail(webSocket, t, response);
        if (response != null) {
            response.close();
        }
    }

    public abstract void onSuccess(WebSocket var1, IgrResponseData var2);

    public abstract void onFail(WebSocket var1, Throwable var2, Response var3);
}

