/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.WebSocketClient;
import cn.xfyun.service.tts.AbstractTtsWebSocketListener;
import cn.xfyun.util.OkHttpUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;

public class TtsClient
extends WebSocketClient {
    private static final String MINOR_LANGUAGE = "UNICODE";
    private static final String MP3 = "lame";
    private String aue;
    private Integer sfl;
    private String auf;
    private String vcn;
    private Integer speed;
    private Integer volume;
    private Integer pitch;
    private Integer bgs;
    private String tte;
    private String reg;
    private String rdn;
    private String ent;

    public TtsClient(Builder builder) {
        this.okHttpClient = builder.httpClient != null ? builder.httpClient : OkHttpUtils.client.newBuilder().connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS).callTimeout((long)builder.callTimeout, TimeUnit.MILLISECONDS).pingInterval((long)builder.pingInterval, TimeUnit.MILLISECONDS).retryOnConnectionFailure(builder.retryOnConnectionFailure).build();
        this.originHostUrl = builder.hostUrl;
        this.appId = builder.appId;
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.aue = builder.aue;
        this.sfl = builder.sfl;
        this.auf = builder.auf;
        this.vcn = builder.vcn;
        this.speed = builder.speed;
        this.volume = builder.volume;
        this.pitch = builder.pitch;
        this.bgs = builder.bgs;
        this.tte = builder.tte;
        this.reg = builder.reg;
        this.rdn = builder.rdn;
        this.ent = builder.ent;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public String getAue() {
        return this.aue;
    }

    public Integer getSfl() {
        return this.sfl;
    }

    public String getAuf() {
        return this.auf;
    }

    public String getVcn() {
        return this.vcn;
    }

    public Integer getSpeed() {
        return this.speed;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public Integer getPitch() {
        return this.pitch;
    }

    public Integer getBgs() {
        return this.bgs;
    }

    public String getTte() {
        return this.tte;
    }

    public String getReg() {
        return this.reg;
    }

    public String getRdn() {
        return this.rdn;
    }

    public String getEnt() {
        return this.ent;
    }

    public OkHttpClient getClient() {
        return this.okHttpClient;
    }

    public void send(String text, AbstractTtsWebSocketListener webSocketListener) throws UnsupportedEncodingException, MalformedURLException, SignatureException {
        this.createWebSocketConnect(webSocketListener);
        text = MINOR_LANGUAGE.equals(this.tte) ? Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_16LE)) : Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8));
        JsonObject frame = new JsonObject();
        JsonObject common = new JsonObject();
        JsonObject business = new JsonObject();
        JsonObject data = new JsonObject();
        common.addProperty("app_id", this.appId);
        business.addProperty("aue", this.aue);
        business.addProperty("sfl", (Number)this.sfl);
        business.addProperty("auf", this.auf);
        business.addProperty("vcn", this.vcn);
        business.addProperty("speed", (Number)this.speed);
        business.addProperty("volume", (Number)this.volume);
        business.addProperty("pitch", (Number)this.pitch);
        business.addProperty("bgs", (Number)this.bgs);
        business.addProperty("tte", this.tte);
        business.addProperty("reg", this.reg);
        business.addProperty("rdn", this.rdn);
        business.addProperty("ent", this.ent);
        data.addProperty("text", text);
        data.addProperty("status", (Number)2);
        frame.add("common", (JsonElement)common);
        frame.add("business", (JsonElement)business);
        frame.add("data", (JsonElement)data);
        this.webSocket.send(frame.toString());
    }

    public static final class Builder {
        private boolean retryOnConnectionFailure = true;
        private int callTimeout = 0;
        private int connectTimeout = 10000;
        private int readTimeout = 30000;
        private int writeTimeout = 30000;
        private int pingInterval = 0;
        private String hostUrl = "https://tts-api.xfyun.cn/v2/tts";
        private String appId;
        private String apiKey;
        private String apiSecret;
        private String aue = "lame";
        private Integer sfl = 1;
        private String auf = "audio/L16;rate=16000";
        private String vcn = "xiaoyan";
        private Integer speed = 50;
        private Integer volume = 50;
        private Integer pitch = 50;
        private Integer bgs = 0;
        private String tte = "UTF8";
        private String reg = "0";
        private String rdn = "0";
        private String ent = "intp65";
        private OkHttpClient httpClient;

        public TtsClient build() {
            return new TtsClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            this.appId = appId;
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder aue(String aue) {
            this.aue = aue;
            return this;
        }

        public Builder sfl(Integer sfl) {
            this.sfl = TtsClient.MP3.equals(this.aue) ? Integer.valueOf(1) : sfl;
            return this;
        }

        public Builder auf(String auf) {
            this.auf = auf;
            return this;
        }

        public Builder vcn(String vcn) {
            this.vcn = vcn;
            return this;
        }

        public Builder speed(Integer speed) {
            this.speed = speed;
            return this;
        }

        public Builder volume(Integer volume) {
            this.volume = volume;
            return this;
        }

        public Builder pitch(Integer pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder bgs(Integer bgs) {
            this.bgs = bgs;
            return this;
        }

        public Builder tte(String tte) {
            this.tte = tte;
            return this;
        }

        public Builder reg(String reg) {
            this.reg = reg;
            return this;
        }

        public Builder rdn(String rdn) {
            this.rdn = rdn;
            return this;
        }

        public Builder ent(String ent) {
            this.ent = ent;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }
    }
}

