/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.model.request.telerobot.Callout;
import cn.xfyun.model.request.telerobot.TaskCreate;
import cn.xfyun.model.request.telerobot.TaskInsert;
import cn.xfyun.model.request.telerobot.TaskQuery;
import cn.xfyun.model.response.telerobot.TelerobotCallout;
import cn.xfyun.model.response.telerobot.TelerobotCreate;
import cn.xfyun.model.response.telerobot.TelerobotQuery;
import cn.xfyun.model.response.telerobot.TelerobotResponse;
import cn.xfyun.model.response.telerobot.TelerobotTaskQuery;
import cn.xfyun.model.response.telerobot.TelerobotToken;
import cn.xfyun.util.HttpConnector;
import cn.xfyun.util.StringUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class TelerobotClient {
    private String hostUrl;
    private String appKey;
    private String appSecret;
    private HttpConnector connector;

    public TelerobotClient(Builder builder) {
        this.appKey = builder.appKey;
        this.appSecret = builder.appSecret;
        this.connector = builder.connector;
    }

    public TelerobotResponse<TelerobotToken> token() throws IOException {
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/oauth/v1/token";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("app_key", this.appKey);
        body.put("app_secret", this.appSecret);
        String result = this.connector.postByJson(this.hostUrl, StringUtils.gson.toJson(body));
        Type jsonType = new TypeToken<TelerobotResponse<TelerobotToken>>(){}.getType();
        return (TelerobotResponse)StringUtils.gson.fromJson(result, jsonType);
    }

    public TelerobotResponse<TelerobotQuery> query(String token, Integer type) throws IOException {
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/config/v1/query?token=" + token;
        String param = "{\"type\":\"" + type + "\"}";
        String result = this.connector.postByJson(this.hostUrl, param);
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<TelerobotQuery>>(){}.getType());
    }

    public TelerobotResponse<TelerobotCallout> callout(String token, Callout callout) throws IOException {
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/callout?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, StringUtils.gson.toJson((Object)callout));
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<TelerobotCallout>>(){}.getType());
    }

    public TelerobotResponse<TelerobotCreate> createTask(String token, TaskCreate taskCreate) throws IOException {
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/create?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, StringUtils.gson.toJson((Object)taskCreate));
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<TelerobotCreate>>(){}.getType());
    }

    public TelerobotResponse<TelerobotCallout> insertTask(String token, TaskInsert taskInsert) throws IOException {
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/insert?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, StringUtils.gson.toJson((Object)taskInsert));
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<TelerobotCallout>>(){}.getType());
    }

    public TelerobotResponse<String> startTask(String token, String taskId) throws IOException {
        String param = "{\"task_id\":\"" + taskId + "\"}";
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/start?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, param);
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<Object>>(){}.getType());
    }

    public TelerobotResponse<String> pauseTask(String token, String taskId) throws IOException {
        String param = "{\"task_id\":\"" + taskId + "\"}";
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/pause?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, param);
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<Object>>(){}.getType());
    }

    public TelerobotResponse<String> deleteTask(String token, String taskId) throws IOException {
        String param = "{\"task_id\":\"" + taskId + "\"}";
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/delete?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, param);
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<Object>>(){}.getType());
    }

    public TelerobotResponse<TelerobotTaskQuery> queryTask(String token, TaskQuery taskQuery) throws IOException {
        this.hostUrl = "https://callapi.xfyun.cn/v1/service/v1/aicall/outbound/v1/task/query?token=" + token;
        String result = this.connector.postByJson(this.hostUrl, StringUtils.gson.toJson((Object)taskQuery));
        return (TelerobotResponse)StringUtils.gson.fromJson(result, new TypeToken<TelerobotResponse<TelerobotTaskQuery>>(){}.getType());
    }

    public static final class Builder {
        private final String appKey;
        private final String appSecret;
        private Integer maxConnections = 50;
        private Integer connTimeout = 10000;
        private Integer soTimeout = 30000;
        private Integer retryCount = 3;
        private HttpConnector connector;

        public Builder(String appKey, String appSecret) {
            this.appKey = appKey;
            this.appSecret = appSecret;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connTimeout(Integer connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder soTimeout(Integer soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public TelerobotClient build() {
            this.connector = HttpConnector.build((int)this.maxConnections, (int)this.connTimeout, (int)this.soTimeout, (int)this.retryCount);
            return new TelerobotClient(this);
        }
    }
}

