/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.WebSocketClient;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.model.sign.RtasrSignature;
import cn.xfyun.service.rta.AbstractRtasrWebSocketListener;
import cn.xfyun.service.rta.RtasrSendTask;
import cn.xfyun.util.OkHttpUtils;
import cn.xfyun.util.StringUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okio.ByteString;

public class RtasrClient
extends WebSocketClient {
    private static final String RTASR_URL = "wss://rtasr.xfyun.cn/v1/ws";
    public static final String SEND_END = "{\"end\": true}";
    private String punc;
    private String pd;
    private String lang;
    private String transType;
    private Integer transStrategy;
    private String targetLang;
    private Integer vadMdn;
    private Integer roleType;
    private Integer engLangType;
    private ExecutorService executorService;

    public RtasrClient(Builder builder) {
        this.okHttpClient = builder.httpClient != null ? builder.httpClient : OkHttpUtils.client.newBuilder().connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS).callTimeout((long)builder.callTimeout, TimeUnit.MILLISECONDS).pingInterval((long)builder.pingInterval, TimeUnit.MILLISECONDS).retryOnConnectionFailure(builder.retryOnConnectionFailure).build();
        this.executorService = null == builder.executor ? Executors.newSingleThreadExecutor() : builder.executor;
        this.appId = builder.appId;
        this.apiKey = builder.apiKey;
        this.request = builder.request;
        this.webSocket = builder.webSocket;
        this.pd = builder.pd;
        this.punc = builder.punc;
        this.lang = builder.lang;
        this.transType = builder.transType;
        this.transStrategy = builder.transStrategy;
        this.targetLang = builder.targetLang;
        this.vadMdn = builder.vadMdn;
        this.roleType = builder.roleType;
        this.engLangType = builder.engLangType;
        if (Objects.isNull(builder.hostUrl)) {
            this.originHostUrl = RTASR_URL;
            this.hostUrl = RTASR_URL;
        } else {
            this.originHostUrl = builder.hostUrl;
            this.hostUrl = builder.hostUrl;
        }
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
    }

    protected void createWebSocketConnect(WebSocketListener webSocketListener) throws SignatureException {
        this.signature = new RtasrSignature(this.appId, this.apiKey);
        String url = RTASR_URL + this.signature.getSigna() + this.getLinkParam();
        this.request = new Request.Builder().url(url).build();
        this.webSocket = this.okHttpClient.newWebSocket(this.request, webSocketListener);
    }

    public void start(WebSocketListener webSocketListener) throws SignatureException {
        this.createWebSocketConnect(webSocketListener);
    }

    public void sendMessage(byte[] bytes) {
        if (null == bytes) {
            this.webSocket.send("");
        } else {
            this.webSocket.send(ByteString.of((byte[])bytes));
        }
    }

    public void send(InputStream inputStream, AbstractRtasrWebSocketListener webSocketListener) throws SignatureException {
        if (inputStream == null) {
            return;
        }
        this.createWebSocketConnect(webSocketListener);
        RtasrSendTask rtasrSendTask = new RtasrSendTask();
        new RtasrSendTask.Builder().inputStream(inputStream).webSocket(this.webSocket).build(rtasrSendTask);
        this.executorService.submit(rtasrSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, AbstractRtasrWebSocketListener webSocketListener) throws SignatureException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        this.createWebSocketConnect(webSocketListener);
        RtasrSendTask iatSendTask = new RtasrSendTask();
        new RtasrSendTask.Builder().bytes(bytes).webSocket(this.webSocket).closeable(closeable).build(iatSendTask);
        this.executorService.submit(iatSendTask);
    }

    public WebSocket newWebSocket(AbstractRtasrWebSocketListener webSocketListener) {
        String url = RTASR_URL + new RtasrSignature(this.appId, this.apiKey).getSigna();
        this.request = new Request.Builder().url(url).build();
        this.webSocket = this.okHttpClient.newWebSocket(this.request, (WebSocketListener)webSocketListener);
        return this.webSocket;
    }

    public void sendEnd() {
        this.webSocket.send(SEND_END);
        this.closeWebsocket();
    }

    private String getLinkParam() {
        StringBuilder param = new StringBuilder();
        if (!StringUtils.isNullOrEmpty((String)this.punc)) {
            param.append("&punc=").append(this.punc);
        }
        if (!StringUtils.isNullOrEmpty((String)this.pd)) {
            param.append("&pd=").append(this.pd);
        }
        if (!StringUtils.isNullOrEmpty((String)this.lang)) {
            param.append("&lang=").append(this.lang);
        }
        if (!StringUtils.isNullOrEmpty((String)this.transType)) {
            param.append("&transType=").append(this.transType);
        }
        if (null != this.transStrategy) {
            param.append("&transStrategy=").append(this.transStrategy);
        }
        if (!StringUtils.isNullOrEmpty((String)this.targetLang)) {
            param.append("&targetLang=").append(this.targetLang);
        }
        if (null != this.vadMdn) {
            param.append("&vadMdn=").append(this.vadMdn);
        }
        if (null != this.roleType) {
            param.append("&roleType=").append(this.roleType);
        }
        if (null != this.engLangType) {
            param.append("&engLangType=").append(this.engLangType);
        }
        return param.toString();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String getPunc() {
        return this.punc;
    }

    public String getPd() {
        return this.pd;
    }

    public String getLang() {
        return this.lang;
    }

    public String getTransType() {
        return this.transType;
    }

    public int getTransStrategy() {
        return this.transStrategy;
    }

    public String getTargetLang() {
        return this.targetLang;
    }

    public Integer getVadMdn() {
        return this.vadMdn;
    }

    public Integer getRoleType() {
        return this.roleType;
    }

    public Integer getEngLangType() {
        return this.engLangType;
    }

    public String getHostUrl() {
        return this.originHostUrl;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public Request getRequest() {
        return this.request;
    }

    public AbstractSignature getSignature() {
        return this.signature;
    }

    public static final class Builder {
        boolean retryOnConnectionFailure = true;
        int callTimeout = 0;
        int connectTimeout = 10000;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        int pingInterval = 0;
        private String hostUrl;
        private String appId;
        private String apiKey;
        private Request request;
        private WebSocket webSocket;
        private String punc;
        private String pd;
        private String lang;
        private String transType;
        private Integer transStrategy;
        private String targetLang;
        private Integer vadMdn;
        private Integer roleType;
        private Integer engLangType;
        private ExecutorService executor;
        private OkHttpClient httpClient;

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder webSocket(WebSocket webSocket) {
            this.webSocket = webSocket;
            return this;
        }

        public Builder addPunc() {
            this.punc = "0";
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder addPd(String pd) {
            this.pd = pd;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder signature(String appId, String apiKey) {
            this.appId = appId;
            this.apiKey = apiKey;
            return this;
        }

        public RtasrClient build() {
            return new RtasrClient(this);
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder transType(String transType) {
            this.transType = transType;
            return this;
        }

        public Builder transStrategy(int transStrategy) {
            this.transStrategy = transStrategy;
            return this;
        }

        public Builder targetLang(String targetLang) {
            this.targetLang = targetLang;
            return this;
        }

        public Builder vadMdn(int vadMdn) {
            this.vadMdn = vadMdn;
            return this;
        }

        public Builder roleType(int roleType) {
            this.roleType = roleType;
            return this;
        }

        public Builder engLangType(int engLangType) {
            this.engLangType = engLangType;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }
    }
}

