/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.aiui.knowledge;

import cn.xfyun.exception.BusinessException;
import cn.xfyun.util.StringUtils;
import java.io.File;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class UploadParam {
    private Long uid;
    private String sid;
    private String groupId;
    private List<File> files;
    private String labels;
    private List<FileInfo> fileList;
    private ParseConfig parseConfig;

    public UploadParam(Builder builder) {
        this.uid = builder.uid;
        this.sid = builder.sid;
        this.groupId = builder.groupId;
        this.files = builder.files;
        this.labels = builder.labels;
        this.fileList = builder.fileList;
        this.parseConfig = builder.parseConfig;
    }

    public UploadParam() {
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public List<FileInfo> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<FileInfo> fileList) {
        this.fileList = fileList;
    }

    public ParseConfig getParseConfig() {
        return this.parseConfig;
    }

    public void setParseConfig(ParseConfig parseConfig) {
        this.parseConfig = parseConfig;
    }

    public void uploadCheck() {
        if (null == this.uid) {
            throw new BusinessException("uid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)this.groupId)) {
            throw new BusinessException("groupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((null == this.files || this.files.isEmpty()) && (null == this.fileList || this.fileList.isEmpty())) {
            throw new BusinessException("files\u548cfileList\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    public RequestBody toFormDataBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (null != this.uid) {
            builder.addFormDataPart("uid", String.valueOf(this.uid));
        }
        if (!StringUtils.isNullOrEmpty((String)this.sid)) {
            builder.addFormDataPart("sid", this.sid);
        }
        if (null != this.files && !this.files.isEmpty()) {
            for (File file : this.files) {
                builder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MultipartBody.FORM, (File)file));
            }
        } else if (null != this.fileList && !this.fileList.isEmpty()) {
            builder.addFormDataPart("fileListStr", StringUtils.gson.toJson(this.fileList));
        }
        if (!StringUtils.isNullOrEmpty((String)this.groupId)) {
            builder.addFormDataPart("groupId", this.groupId);
        }
        if (!StringUtils.isNullOrEmpty((String)this.labels)) {
            builder.addFormDataPart("labels", this.labels);
        }
        if (null != this.parseConfig) {
            builder.addFormDataPart("parseConfig", StringUtils.gson.toJson((Object)this.parseConfig));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJSONString() {
        return StringUtils.gson.toJson((Object)this);
    }

    public static final class Builder {
        private Long uid;
        private String sid;
        private String groupId;
        private List<File> files;
        private String labels;
        private List<FileInfo> fileList;
        private ParseConfig parseConfig;

        private Builder() {
        }

        public UploadParam build() {
            return new UploadParam(this);
        }

        public Builder uid(long uid) {
            this.uid = uid;
            return this;
        }

        public Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder files(List<File> files) {
            this.files = files;
            return this;
        }

        public Builder labels(String labels) {
            this.labels = labels;
            return this;
        }

        public Builder fileList(List<FileInfo> fileList) {
            this.fileList = fileList;
            return this;
        }

        public Builder parseConfig(ParseConfig parseConfig) {
            this.parseConfig = parseConfig;
            return this;
        }
    }

    public static class ParseConfig {
        private String chunkType;
        private String separator;
        private String cutLevel;
        private String lengthRange;
        private String cutOff;

        public ParseConfig() {
        }

        public ParseConfig(String chunkType, String separator, String cutLevel, String lengthRange, String cutOff) {
            this.chunkType = chunkType;
            this.separator = separator;
            this.cutLevel = cutLevel;
            this.lengthRange = lengthRange;
            this.cutOff = cutOff;
        }

        public String getChunkType() {
            return this.chunkType;
        }

        public void setChunkType(String chunkType) {
            this.chunkType = chunkType;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public String getCutLevel() {
            return this.cutLevel;
        }

        public void setCutLevel(String cutLevel) {
            this.cutLevel = cutLevel;
        }

        public String getLengthRange() {
            return this.lengthRange;
        }

        public void setLengthRange(String lengthRange) {
            this.lengthRange = lengthRange;
        }

        public String getCutOff() {
            return this.cutOff;
        }

        public void setCutOff(String cutOff) {
            this.cutOff = cutOff;
        }
    }

    public static class FileInfo {
        private String fileName;
        private String filePath;
        private Long fileSize;

        public FileInfo() {
        }

        public FileInfo(String fileName, String filePath, Long fileSize) {
            this.fileName = fileName;
            this.filePath = filePath;
            this.fileSize = fileSize;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public Long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }
    }
}

