/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.config;

public enum LanguageEnum {
    CHINESE("\u4e2d\u6587\u666e\u901a\u8bdd", 0),
    ENGLISH("\u82f1\u8bed", 1),
    JAPANESE("\u65e5\u8bed", 2),
    KOREAN("\u97e9\u8bed", 3),
    RUSSIAN("\u4fc4\u8bed", 4),
    FRENCH("\u6cd5\u8bed", 5),
    ARABIC("\u963f\u62c9\u4f2f\u8bed", 6),
    SPANISH("\u897f\u73ed\u7259\u8bed", 7),
    CANTONESE("\u7ca4\u8bed", 8);

    private final String description;
    private final int code;

    private LanguageEnum(String description, int code) {
        this.description = description;
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return this.code + " -> " + this.description;
    }

    public static LanguageEnum getByCode(int code) {
        for (LanguageEnum language : LanguageEnum.values()) {
            if (language.getCode() != code) continue;
            return language;
        }
        return null;
    }

    public static LanguageEnum getByDescription(String description) {
        for (LanguageEnum language : LanguageEnum.values()) {
            if (!language.getDescription().equals(description)) continue;
            return language;
        }
        return null;
    }
}

