/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.voiceclone.VoiceCloneParam;
import cn.xfyun.model.voiceclone.request.VoiceCloneRequest;
import cn.xfyun.util.StringUtils;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Base64;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoiceCloneV2Client
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(VoiceCloneV2Client.class);
    private final String textEncoding;
    private final String textCompress;
    private final String textFormat;
    private final String encoding;
    private final int sampleRate;
    private final int status;
    private final int pybuffer;

    public VoiceCloneV2Client(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.textEncoding = builder.textEncoding;
        this.textCompress = builder.textCompress;
        this.textFormat = builder.textFormat;
        this.encoding = builder.encoding;
        this.sampleRate = builder.sampleRate;
        this.status = builder.status;
        this.pybuffer = builder.pybuffer;
    }

    public int getPybuffer() {
        return this.pybuffer;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public String getTextCompress() {
        return this.textCompress;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public int getStatus() {
        return this.status;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void send(VoiceCloneParam voiceCloneParam, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.paramCheck(voiceCloneParam);
        WebSocket socket = this.newWebSocket(webSocketListener);
        try {
            String param = this.buildParam(voiceCloneParam);
            logger.debug("\u4e00\u53e5\u8bdd\u590d\u523b\u5408\u6210\u5165\u53c2\uff1a{}", (Object)param);
            socket.send(param);
        }
        catch (Exception e) {
            logger.error("\u4e00\u53e5\u8bdd\u590d\u523b\u5408\u6210\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
    }

    private void paramCheck(VoiceCloneParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.selfCheck();
    }

    private String buildParam(VoiceCloneParam param) {
        VoiceCloneRequest request = new VoiceCloneRequest();
        VoiceCloneRequest.Header header = new VoiceCloneRequest.Header();
        header.setAppId(this.appId);
        header.setStatus(this.status);
        header.setResId(param.getResId());
        request.setHeader(header);
        VoiceCloneRequest.Parameter parameter = new VoiceCloneRequest.Parameter();
        VoiceCloneRequest.Parameter.Tts tts = new VoiceCloneRequest.Parameter.Tts();
        VoiceCloneRequest.Parameter.Tts.Audio audio = new VoiceCloneRequest.Parameter.Tts.Audio();
        tts.setSpeed(param.getSpeed());
        tts.setVolume(param.getVolume());
        tts.setPitch(param.getPitch());
        tts.setLanguageId(param.getLanguageId());
        tts.setBgs(param.getBgs());
        tts.setReg(param.getReg());
        tts.setRdn(param.getRdn());
        tts.setRhy(param.getRhy());
        tts.setVcn(param.getVcn());
        tts.setStyle(param.getStyle());
        tts.setPybuffer(this.pybuffer);
        audio.setEncoding(this.encoding);
        audio.setSampleRate(this.sampleRate);
        tts.setAudio(audio);
        parameter.setTts(tts);
        request.setParameter(parameter);
        VoiceCloneRequest.Payload payload = new VoiceCloneRequest.Payload();
        VoiceCloneRequest.Payload.Text payloadText = new VoiceCloneRequest.Payload.Text();
        payloadText.setEncoding(this.textEncoding);
        payloadText.setCompress(this.textCompress);
        payloadText.setFormat(this.textFormat);
        payloadText.setStatus(this.status);
        payloadText.setSeq(0);
        payloadText.setText(Base64.getEncoder().encodeToString(param.getText().getBytes(StandardCharsets.UTF_8)));
        payload.setText(payloadText);
        request.setPayload(payload);
        return StringUtils.gson.toJson((Object)request);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "http://cn-huabei-1.xf-yun.com/v1/private/voice_clone";
        private String textEncoding = "utf8";
        private String textCompress = "raw";
        private String textFormat = "plain";
        private String encoding = "lame";
        private int sampleRate = 24000;
        private int status = 2;
        private int pybuffer = 1;

        public VoiceCloneV2Client build() {
            return new VoiceCloneV2Client(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            return this;
        }

        public Builder pybuffer(int pybuffer) {
            this.pybuffer = pybuffer;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder textEncoding(String textEncoding) {
            this.textEncoding = textEncoding;
            return this;
        }

        public Builder textCompress(String textCompress) {
            this.textCompress = textCompress;
            return this;
        }

        public Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }
    }
}

