/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.model.sparkmodel.FileContent;
import cn.xfyun.model.sparkmodel.FunctionCall;
import cn.xfyun.model.sparkmodel.request.KnowledgeFileUpload;
import cn.xfyun.model.sparkmodel.request.SparkCustomRequest;
import cn.xfyun.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.List;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCustomClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(SparkCustomClient.class);
    private final String domain;
    private final Float temperature;
    private final Integer topK;
    private final Integer maxTokens;
    private final List<FunctionCall> functions;
    private final String createKnowledgeUrl;
    private final String uploadFileUrl;
    private final String userId;

    public SparkCustomClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.domain = builder.domain;
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.maxTokens = builder.maxTokens;
        this.functions = builder.functions;
        this.createKnowledgeUrl = builder.createKnowledgeUrl;
        this.uploadFileUrl = builder.uploadFileUrl;
        this.userId = builder.userId;
    }

    public String getCreateKnowledgeUrl() {
        return this.createKnowledgeUrl;
    }

    public String getUploadFileUrl() {
        return this.uploadFileUrl;
    }

    public List<FunctionCall> getFunctions() {
        return this.functions;
    }

    public String getDomain() {
        return this.domain;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public String getUserId() {
        return this.userId;
    }

    public void send(List<FileContent> text, List<FunctionCall> functions, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.textCheck(text);
        WebSocket webSocket = this.newWebSocket(webSocketListener);
        try {
            String jsonStr = this.buildParam(text, functions);
            logger.info("\u661f\u706b\u81ea\u5b9a\u4e49\u5927\u6a21\u578bws\u53c2\u6570\uff1a{}", (Object)jsonStr);
            webSocket.send(jsonStr);
        }
        catch (Exception e) {
            logger.error("ws\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public String create(String knowledgeName) throws IOException {
        this.createCheck(knowledgeName);
        String realUrl = Signature.signHostDateAuthorization((String)this.createKnowledgeUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        Request requestUrl = this.getRequest(knowledgeName, realUrl);
        try (Response response = this.okHttpClient.newCall(requestUrl).execute();){
            String string = Objects.requireNonNull(response.body(), "\u521b\u5efa\u77e5\u8bc6\u5e93\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a").string();
            return string;
        }
    }

    public String upload(KnowledgeFileUpload upload) throws IOException {
        this.uploadCheck(upload);
        String realUrl = Signature.signHostDateAuthorization((String)this.uploadFileUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        Request requestUrl = this.getFormDataRequest(upload, realUrl);
        try (Response response = this.okHttpClient.newCall(requestUrl).execute();){
            String string = Objects.requireNonNull(response.body(), "\u4e0a\u4f20\u6587\u4ef6\u5230\u77e5\u8bc6\u5e93\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a").string();
            return string;
        }
    }

    private void uploadCheck(KnowledgeFileUpload upload) {
        if (upload == null) {
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        upload.selfCheck();
    }

    private void createCheck(String knowledgeName) {
        if (StringUtils.isNullOrEmpty((String)knowledgeName)) {
            throw new BusinessException("\u77e5\u8bc6\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (knowledgeName.length() > 32) {
            throw new BusinessException("\u77e5\u8bc6\u5e93\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732\u5b57\u7b26");
        }
    }

    private void textCheck(List<FileContent> text) {
        if (text == null || text.isEmpty()) {
            throw new BusinessException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(List<FileContent> text, List<FunctionCall> functions) {
        SparkCustomRequest request = new SparkCustomRequest();
        SparkCustomRequest.Header header = new SparkCustomRequest.Header(this.appId, this.userId);
        request.setHeader(header);
        SparkCustomRequest.Parameter parameter = new SparkCustomRequest.Parameter(this);
        request.setParameter(parameter);
        SparkCustomRequest.Payload payload = new SparkCustomRequest.Payload();
        SparkCustomRequest.Payload.Message message = new SparkCustomRequest.Payload.Message();
        message.setText(text);
        payload.setMessage(message);
        List<FunctionCall> list = functions = null != functions && !functions.isEmpty() ? functions : this.functions;
        if (null != functions && !functions.isEmpty()) {
            SparkCustomRequest.Payload.Function function = new SparkCustomRequest.Payload.Function();
            function.setText(functions);
            payload.setFunctions(function);
        }
        request.setPayload(payload);
        return StringUtils.gson.toJson((Object)request);
    }

    private Request getFormDataRequest(KnowledgeFileUpload param, String url) {
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("purpose", param.getPurpose()).addFormDataPart("kb_id", param.getKnowledgeName()).addFormDataPart("file", param.getFile().getName(), RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (File)param.getFile())).build();
        return new Request.Builder().url(url).method("POST", (RequestBody)body).addHeader("x-appid", this.appId).build();
    }

    private Request getRequest(String knowledgeName, String url) {
        FormBody requestBody = new FormBody.Builder().add("kb_id", knowledgeName).build();
        return new Request.Builder().url(url).method("POST", (RequestBody)requestBody).addHeader("x-appid", this.appId).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "https://sparkcube-api.xf-yun.com/v1/customize";
        private String createKnowledgeUrl = "https://sparkcube-api.xf-yun.com/v1/knowledge/create";
        private String uploadFileUrl = "https://sparkcube-api.xf-yun.com/v1/files";
        private String domain = "max";
        private Float temperature = Float.valueOf(0.5f);
        private Integer topK = 4;
        private Integer maxTokens = 4096;
        private List<FunctionCall> functions;
        private String userId;

        public SparkCustomClient build() {
            return new SparkCustomClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder createKnowledgeUrl(String createKnowledgeUrl) {
            this.createKnowledgeUrl = createKnowledgeUrl;
            return this;
        }

        public Builder uploadFileUrl(String uploadFileUrl) {
            this.uploadFileUrl = uploadFileUrl;
            return this;
        }

        public Builder functions(List<FunctionCall> functions) {
            this.functions = functions;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

