/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.oral.request.OralRequest;
import cn.xfyun.util.StringUtils;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Base64;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OralClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(OralClient.class);
    private static final int STATUS = 2;
    private static final String TEXT_ENCODING = "utf8";
    private static final String TEXT_COMPRESS = "raw";
    private final String oralLevel;
    private final int sparkAssist;
    private final int stopSplit;
    private final int remain;
    private final String vcn;
    private final int speed;
    private final int volume;
    private final int pitch;
    private final int bgs;
    private final int reg;
    private final int rdn;
    private final int rhy;
    private final String encoding;
    private final int sampleRate;
    private final int channels;
    private final int bitDepth;
    private final int frameSize;
    private final String textFormat;

    public OralClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.oralLevel = builder.oralLevel;
        this.sparkAssist = builder.sparkAssist;
        this.stopSplit = builder.stopSplit;
        this.remain = builder.remain;
        this.vcn = builder.vcn;
        this.speed = builder.speed;
        this.volume = builder.volume;
        this.pitch = builder.pitch;
        this.bgs = builder.bgs;
        this.reg = builder.reg;
        this.rdn = builder.rdn;
        this.rhy = builder.rhy;
        this.encoding = builder.encoding;
        this.sampleRate = builder.sampleRate;
        this.channels = builder.channels;
        this.bitDepth = builder.bitDepth;
        this.frameSize = builder.frameSize;
        this.textFormat = builder.textFormat;
    }

    public String getOralLevel() {
        return this.oralLevel;
    }

    public int getSparkAssist() {
        return this.sparkAssist;
    }

    public int getStopSplit() {
        return this.stopSplit;
    }

    public int getRemain() {
        return this.remain;
    }

    public String getVcn() {
        return this.vcn;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getBgs() {
        return this.bgs;
    }

    public int getReg() {
        return this.reg;
    }

    public int getRdn() {
        return this.rdn;
    }

    public int getRhy() {
        return this.rhy;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public void send(String text, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        WebSocket socket = this.newWebSocket(webSocketListener);
        String jsonStr = this.buildParam(text);
        try {
            logger.debug("\u8d85\u62df\u4eba\u5408\u6210\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)jsonStr);
            socket.send(jsonStr);
        }
        catch (Exception e) {
            logger.error("\u8d85\u62df\u4eba\u5408\u6210\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
    }

    private void paramCheck(String text) {
        if (StringUtils.isNullOrEmpty((String)text)) {
            throw new BusinessException("\u5408\u6210\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 8000) {
            throw new BusinessException("\u5408\u6210\u6587\u672c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc78000\u5b57\u8282");
        }
    }

    private String buildParam(String text) {
        OralRequest request = new OralRequest();
        OralRequest.Header header = new OralRequest.Header();
        header.setAppId(this.appId);
        header.setStatus(2);
        request.setHeader(header);
        OralRequest.Parameter parameter = new OralRequest.Parameter(this);
        request.setParameter(parameter);
        OralRequest.Payload payload = new OralRequest.Payload();
        OralRequest.Payload.Text payloadText = new OralRequest.Payload.Text();
        payloadText.setEncoding(TEXT_ENCODING);
        payloadText.setCompress(TEXT_COMPRESS);
        payloadText.setFormat(this.textFormat);
        payloadText.setStatus(2);
        payloadText.setSeq(0);
        payloadText.setText(Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
        payload.setText(payloadText);
        request.setPayload(payload);
        return StringUtils.gson.toJson((Object)request);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "https://cbm01.cn-huabei-1.xf-yun.com/v1/private/mcd9m97e6";
        private String oralLevel = "mid";
        private int sparkAssist = 1;
        private int stopSplit = 0;
        private int remain = 0;
        private String vcn = "x4_lingxiaoxuan_oral";
        private int speed = 50;
        private int volume = 50;
        private int pitch = 50;
        private int bgs = 0;
        private int reg = 0;
        private int rdn = 0;
        private int rhy = 0;
        private String encoding = "lame";
        private int sampleRate = 24000;
        private int channels = 1;
        private int bitDepth = 16;
        private int frameSize = 0;
        private String textFormat = "plain";

        public OralClient build() {
            return new OralClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder oralLevel(String oralLevel) {
            this.oralLevel = oralLevel;
            return this;
        }

        public Builder sparkAssist(int sparkAssist) {
            this.sparkAssist = sparkAssist;
            return this;
        }

        public Builder stopSplit(int stopSplit) {
            this.stopSplit = stopSplit;
            return this;
        }

        public Builder remain(int remain) {
            this.remain = remain;
            return this;
        }

        public Builder vcn(String vcn) {
            this.vcn = vcn;
            return this;
        }

        public Builder speed(int speed) {
            this.speed = speed;
            return this;
        }

        public Builder volume(int volume) {
            this.volume = volume;
            return this;
        }

        public Builder pitch(int pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder bgs(int bgs) {
            this.bgs = bgs;
            return this;
        }

        public Builder reg(int reg) {
            this.reg = reg;
            return this;
        }

        public Builder rdn(int rdn) {
            this.rdn = rdn;
            return this;
        }

        public Builder rhy(int rhy) {
            this.rhy = rhy;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder bitDepth(int bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public Builder frameSize(int frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }
    }
}

