/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.base.websocket.WebsocketBuilder;
import cn.xfyun.config.Role;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sparkmodel.RoleContent;
import cn.xfyun.model.sparkmodel.SparkChatParam;
import cn.xfyun.model.sparkmodel.request.SparkSendRequest;
import cn.xfyun.model.sparkmodel.response.ImageUnderstandResponse;
import cn.xfyun.service.sparkmodel.AbstractImgUnderstandWebSocketListener;
import cn.xfyun.util.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUnderstandClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(ImageUnderstandClient.class);
    private final float temperature;
    private final int maxTokens;
    private final int topK;
    private final String domain;

    public ImageUnderstandClient(Builder builder) {
        super((WebsocketBuilder)builder);
        this.originHostUrl = builder.hostUrl;
        this.temperature = builder.temperature;
        this.maxTokens = builder.maxTokens;
        this.topK = builder.topK;
        this.domain = builder.domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getTopK() {
        return this.topK;
    }

    public String send(String question, String imgBase64) throws IOException, SignatureException {
        SparkChatParam param = this.paramHandler(question, imgBase64);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<String> errorMessage = new AtomicReference<String>();
        StringBuffer result = new StringBuffer();
        this.send(param, this.listenerHandler(latch, errorMessage, result));
        this.waitForSuccess(latch, errorMessage);
        return result.toString();
    }

    public void send(SparkChatParam sparkChatParam, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.paramCheck(sparkChatParam);
        WebSocket webSocket = this.newWebSocket(webSocketListener);
        try {
            String param = this.buildParam(sparkChatParam);
            logger.debug("\u56fe\u50cf\u7406\u89e3ws\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
            webSocket.send(param);
        }
        catch (Exception e) {
            logger.error("ws\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    private void waitForSuccess(CountDownLatch latch, AtomicReference<String> errorMessage) throws SocketTimeoutException {
        try {
            int waitTime = this.readTimeout == 0 ? Integer.MAX_VALUE : this.readTimeout;
            boolean await = latch.await(waitTime, TimeUnit.MILLISECONDS);
            if (!await) {
                throw new SocketTimeoutException("\u8bf7\u6c42\u8d85\u65f6");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (errorMessage.get() != null) {
            throw new BusinessException(errorMessage.get());
        }
    }

    private SparkChatParam paramHandler(String question, String imgBase64) {
        ArrayList<RoleContent> messages = new ArrayList<RoleContent>();
        RoleContent image = RoleContent.builder().role(Role.USER.getValue()).content(imgBase64).contentType("image").build();
        RoleContent q = RoleContent.builder().role(Role.USER.getValue()).content(question).build();
        messages.add(image);
        messages.add(q);
        return SparkChatParam.builder().messages(messages).chatId(null).userId(null).build();
    }

    private AbstractImgUnderstandWebSocketListener listenerHandler(final CountDownLatch latch, final AtomicReference<String> errorMessage, final StringBuffer result) {
        return new AbstractImgUnderstandWebSocketListener(){

            @Override
            public void onSuccess(WebSocket webSocket, ImageUnderstandResponse resp) {
                if (resp.getHeader().getCode() != 0) {
                    logger.error("code=>{}\uff0cerror=>{}\uff0csid=>{}", new Object[]{resp.getHeader().getCode(), resp.getHeader().getMessage(), resp.getHeader().getSid()});
                    errorMessage.set(resp.getHeader().getCode() + ":" + resp.getHeader().getMessage());
                    latch.countDown();
                    webSocket.close(1011, resp.getHeader().getMessage());
                    return;
                }
                if (null != resp.getPayload() && null != resp.getPayload().getChoices()) {
                    List<ImageUnderstandResponse.Payload.Choices.Text> text = resp.getPayload().getChoices().getText();
                    if (null != text && !text.isEmpty()) {
                        IntStream.range(0, text.size()).forEach(index -> {
                            String content = resp.getPayload().getChoices().getText().get(index).getContent();
                            if (!StringUtils.isNullOrEmpty((String)content)) {
                                result.append(content);
                            }
                        });
                    }
                    if (resp.getPayload().getChoices().getStatus() == 2) {
                        latch.countDown();
                        webSocket.close(1000, "");
                    }
                }
            }

            @Override
            public void onFail(WebSocket webSocket, Throwable t, Response response) {
                logger.error(t.getMessage(), t);
                errorMessage.set(t.getMessage());
                latch.countDown();
            }

            @Override
            public void onClose(WebSocket webSocket, int code, String reason) {
                latch.countDown();
            }
        };
    }

    private void paramCheck(SparkChatParam param) {
        if (param.getMessages() == null || param.getMessages().isEmpty()) {
            throw new BusinessException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildParam(SparkChatParam param) {
        SparkSendRequest sendRequest = new SparkSendRequest();
        SparkSendRequest.Header header = new SparkSendRequest.Header(this.appId, param.getUserId());
        sendRequest.setHeader(header);
        SparkSendRequest.Parameter parameter = new SparkSendRequest.Parameter();
        SparkSendRequest.Parameter.Chat chat = new SparkSendRequest.Parameter.Chat();
        chat.setDomain(this.domain);
        chat.setTemperature(Float.valueOf(this.temperature));
        chat.setMaxTokens(this.maxTokens);
        chat.setTopK(this.topK);
        chat.setChatId(param.getChatId());
        parameter.setChat(chat);
        sendRequest.setParameter(parameter);
        SparkSendRequest.Payload payload = new SparkSendRequest.Payload();
        SparkSendRequest.Payload.Message message = new SparkSendRequest.Payload.Message();
        message.setText(param.getMessages());
        payload.setMessage(message);
        sendRequest.setPayload(payload);
        return StringUtils.gson.toJson((Object)sendRequest);
    }

    public static final class Builder
    extends WebsocketBuilder<Builder> {
        private String hostUrl = "https://spark-api.cn-huabei-1.xf-yun.com/v2.1/image";
        private float temperature = 0.5f;
        private int maxTokens = 2028;
        private int topK = 4;
        private String domain = "imagev3";

        public ImageUnderstandClient build() {
            return new ImageUnderstandClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            super.signature(appId, apiKey, apiSecret);
            return this;
        }

        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder topK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }
    }
}

