/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.config.FrameType;
import cn.xfyun.config.StreamMode;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.oralchat.OralChatParam;
import cn.xfyun.model.oralchat.request.OralChatRequest;
import cn.xfyun.util.OkHttpUtils;
import cn.xfyun.util.StringUtils;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OralChatClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(OralChatClient.class);
    private final ConcurrentHashMap<String, OralChatParam> paramCache = new ConcurrentHashMap();
    private final int vgap;
    private final String eos;
    private final String dwa;
    private final String domain;
    private final String textEncoding;
    private final String textCompress;
    private final String textFormat;
    private final String encodingIn;
    private final String encodingOut;
    private final int sampleRateIn;
    private final int sampleRateOut;
    private final int channelsIn;
    private final int channelsOut;
    private final int bitDepthIn;
    private final int bitDepthOut;
    private final int frameSize;

    public OralChatClient(Builder builder) {
        this.okHttpClient = builder.okHttpClient != null ? builder.okHttpClient : OkHttpUtils.client.newBuilder().connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS).callTimeout((long)builder.callTimeout, TimeUnit.MILLISECONDS).pingInterval((long)builder.pingInterval, TimeUnit.MILLISECONDS).retryOnConnectionFailure(builder.retryOnConnectionFailure).build();
        this.originHostUrl = builder.hostUrl;
        this.appId = builder.appId;
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.vgap = builder.vgap;
        this.encodingIn = builder.encodingIn;
        this.encodingOut = builder.encodingOut;
        this.sampleRateIn = builder.sampleRateIn;
        this.sampleRateOut = builder.sampleRateOut;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
        this.bitDepthIn = builder.bitDepthIn;
        this.bitDepthOut = builder.bitDepthOut;
        this.frameSize = builder.frameSize;
        this.textEncoding = builder.textEncoding;
        this.textCompress = builder.textCompress;
        this.textFormat = builder.textFormat;
        this.dwa = builder.dwa;
        this.eos = builder.eos;
        this.domain = builder.domain;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
    }

    public int getVgap() {
        return this.vgap;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public String getTextCompress() {
        return this.textCompress;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public String getEncodingIn() {
        return this.encodingIn;
    }

    public String getEncodingOut() {
        return this.encodingOut;
    }

    public int getSampleRateIn() {
        return this.sampleRateIn;
    }

    public int getSampleRateOut() {
        return this.sampleRateOut;
    }

    public int getChannelsIn() {
        return this.channelsIn;
    }

    public int getChannelsOut() {
        return this.channelsOut;
    }

    public int getBitDepthIn() {
        return this.bitDepthIn;
    }

    public int getBitDepthOut() {
        return this.bitDepthOut;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public String getDwa() {
        return this.dwa;
    }

    public String getEos() {
        return this.eos;
    }

    public String getDomain() {
        return this.domain;
    }

    public WebSocket start(OralChatParam param, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.paramCheck(param);
        WebSocket socket = this.newWebSocket(webSocketListener);
        this.cacheStartParam(param, socket);
        return socket;
    }

    public void stop(WebSocket socket) {
        String uniqueId = String.valueOf(System.identityHashCode(socket));
        OralChatParam param = this.paramCache.remove(uniqueId);
        this.stop(socket, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(WebSocket socket, OralChatParam param) {
        try {
            if (null != param) {
                String msg = this.buildParam(null, 2, param, true);
                socket.send(msg);
            }
        }
        catch (Exception e) {
            logger.error("\u8d85\u62df\u4eba\u4ea4\u4e92\u670d\u52a1\u7aef\u505c\u6b62\u8fd4\u56de\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (socket != null) {
                socket.close(1000, "");
            }
        }
    }

    public void sendMsg(WebSocket socket, byte[] bytes, int status) {
        OralChatParam param = this.getOralChatParam(socket);
        this.sendMsg(socket, bytes, status, param);
    }

    private void sendMsg(WebSocket socket, byte[] bytes, int status, OralChatParam param) {
        if (param == null) {
            logger.error("\u8d85\u62df\u4eba\u4ea4\u4e92\u4f1a\u8bdd\u53c2\u6570\u7f3a\u5931");
            throw new BusinessException("\u8d85\u62df\u4eba\u4ea4\u4e92\u4f1a\u8bdd\u53c2\u6570\u7f3a\u5931");
        }
        String body = this.buildParam(bytes, status, param, false);
        boolean send = socket.send(body);
        if (!send) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u5931\u8d25!");
            throw new BusinessException("\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u5931\u8d25!");
        }
    }

    private OralChatParam getOralChatParam(WebSocket socket) {
        String queueId = String.valueOf(System.identityHashCode(socket));
        return this.paramCache.get(queueId);
    }

    private void cacheStartParam(OralChatParam param, WebSocket socket) {
        String queueId = String.valueOf(System.identityHashCode(socket));
        this.paramCache.put(queueId, param);
    }

    private void paramCheck(OralChatParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.selfCheck();
    }

    private String buildParam(byte[] bytes, int status, OralChatParam param, boolean isEnd) {
        boolean newChat = FrameType.FIRST_FRAME.codeEqual(status);
        boolean firstFrame = newChat && -1 == param.getStmid().get();
        String mode = param.getInteractMode();
        OralChatRequest request = new OralChatRequest();
        OralChatRequest.Header header = this.buildHeader(param, isEnd, firstFrame, mode, newChat);
        request.setHeader(header);
        if (firstFrame || newChat && StreamMode.CONTINUOUS_VAD.modeEquals(mode)) {
            OralChatRequest.Parameter parameter = this.buildParameter(param);
            request.setParameter(parameter);
        }
        int payloadStatus = StreamMode.CONTINUOUS_VAD.modeEquals(mode) ? status : header.getStatus();
        OralChatRequest.Payload payload = this.buildPayload(bytes, payloadStatus);
        request.setPayload(payload);
        String body = StringUtils.gson.toJson((Object)request);
        logger.debug("\u8d85\u62df\u4eba\u4ea4\u4e92\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)body);
        return body;
    }

    private OralChatRequest.Payload buildPayload(byte[] bytes, int status) {
        OralChatRequest.Payload payload = new OralChatRequest.Payload(this);
        payload.getAudio().setStatus(status);
        payload.getAudio().setAudio(bytes == null || bytes.length == 0 ? "" : Base64.getEncoder().encodeToString(bytes));
        return payload;
    }

    private OralChatRequest.Parameter buildParameter(OralChatParam param) {
        OralChatRequest.Parameter parameter = new OralChatRequest.Parameter(this);
        parameter.getNlp().setNewSession(param.getNewSession());
        parameter.getNlp().setPersonal(param.getPersonal());
        parameter.getNlp().setPrompt(param.getPrompt());
        parameter.getTts().setPitch(param.getPitch());
        parameter.getTts().setVolume(param.getVolume());
        parameter.getTts().setSpeed(param.getSpeed());
        parameter.getTts().setResGender(param.getResGender());
        parameter.getTts().setResId(param.getResId());
        parameter.getTts().setVcn(param.getVcn());
        parameter.setAvatar(param.getAvatar());
        return parameter;
    }

    private OralChatRequest.Header buildHeader(OralChatParam param, boolean isEnd, boolean firstFrame, String mode, boolean newChat) {
        OralChatRequest.Header header = new OralChatRequest.Header();
        header.setAppId(this.appId);
        header.setScene(param.getScene());
        header.setUid(param.getUid());
        header.setStmid(String.valueOf(FrameType.FIRST_FRAME.getValue()));
        if (isEnd) {
            header.setStatus(FrameType.LAST_FRAME.getValue());
        } else if (firstFrame) {
            header.setStatus(FrameType.FIRST_FRAME.getValue());
        } else {
            header.setStatus(FrameType.MIDDLE_FRAME.getValue());
        }
        boolean isContinuousVad = StreamMode.CONTINUOUS_VAD.modeEquals(mode);
        if (newChat && isContinuousVad || firstFrame) {
            int next = param.getStmid().incrementAndGet();
            header.setInteractMode(param.getInteractMode());
            header.setOsSys(param.getOsSys());
            header.setPersParam(param.getPersParam());
            header.setStmid(String.valueOf(next));
        } else if (isContinuousVad) {
            header.setStmid(param.getStmid().toString());
        }
        return header;
    }

    public static final class Builder {
        boolean retryOnConnectionFailure = true;
        int callTimeout = 0;
        int connectTimeout = 30000;
        int readTimeout = 30000;
        int writeTimeout = 30000;
        int pingInterval = 0;
        private String hostUrl = "https://sparkos.xfyun.cn/v1/openapi/chat";
        private String appId;
        private String apiKey;
        private String apiSecret;
        private int vgap = 80;
        private String encodingIn = "raw";
        private String encodingOut = "raw";
        private int sampleRateIn = 16000;
        private int sampleRateOut = 16000;
        private int channelsIn = 1;
        private int channelsOut = 1;
        private int bitDepthIn = 16;
        private int bitDepthOut = 16;
        private String textEncoding = "utf8";
        private String textCompress = "raw";
        private String textFormat = "json";
        private String dwa;
        private String eos;
        private String domain;
        private int frameSize = 0;
        private OkHttpClient okHttpClient;

        public OralChatClient build() {
            return new OralChatClient(this);
        }

        public Builder signature(String appId, String apiKey, String apiSecret) {
            this.appId = appId;
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder vgap(int vgap) {
            this.vgap = vgap;
            return this;
        }

        public Builder encodingIn(String encodingIn) {
            this.encodingIn = encodingIn;
            return this;
        }

        public Builder encodingOut(String encodingOut) {
            this.encodingOut = encodingOut;
            return this;
        }

        public Builder sampleRateIn(int sampleRateIn) {
            this.sampleRateIn = sampleRateIn;
            return this;
        }

        public Builder sampleRateOut(int sampleRateOut) {
            this.sampleRateOut = sampleRateOut;
            return this;
        }

        public Builder channelsIn(int channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public Builder channelsOut(int channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public Builder bitDepthIn(int bitDepthIn) {
            this.bitDepthIn = bitDepthIn;
            return this;
        }

        public Builder bitDepthOut(int bitDepthOut) {
            this.bitDepthOut = bitDepthOut;
            return this;
        }

        public Builder frameSize(int frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder textEncoding(String textEncoding) {
            this.textEncoding = textEncoding;
            return this;
        }

        public Builder textCompress(String textCompress) {
            this.textCompress = textCompress;
            return this;
        }

        public Builder textFormat(String textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public Builder dwa(String dwa) {
            this.dwa = dwa;
            return this;
        }

        public Builder eos(String eos) {
            this.eos = eos;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }
    }
}

