/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.platform.PlatformBuilder;
import cn.xfyun.base.http.platform.PlatformHttpClient;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.image.HiDreamParam;
import cn.xfyun.model.image.request.ImageHiDreamRequest;
import cn.xfyun.model.sign.Signature;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiDreamClient
extends PlatformHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HiDreamClient.class);
    private final String searchUrl;

    public HiDreamClient(Builder builder) {
        super((PlatformBuilder)builder);
        this.searchUrl = builder.searchUrl;
    }

    public String getSearchUrl() {
        return this.searchUrl;
    }

    public String send(HiDreamParam param) throws IOException {
        this.paramCheck(param);
        String realUrl = Signature.signHostDateAuthorization((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        String body = this.buildParam(param, realUrl);
        return this.sendPost(realUrl, JSON, null, body);
    }

    public String query(String taskId) throws IOException {
        if (StringUtils.isNullOrEmpty((String)taskId)) {
            throw new BusinessException("taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String realUrl = Signature.signHostDateAuthorization((String)this.searchUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret);
        String body = this.buildQuery(taskId, realUrl);
        return this.sendPost(realUrl, JSON, null, body);
    }

    private String buildQuery(String taskId, String realUrl) {
        JsonObject param = new JsonObject();
        JsonObject header = new JsonObject();
        header.addProperty("app_id", this.appId);
        header.addProperty("task_id", taskId);
        param.add("header", (JsonElement)header);
        logger.debug("HiDream\u56fe\u7247\u751f\u6210\u7ed3\u679c\u67e5\u8be2\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)realUrl, (Object)param);
        return param.toString();
    }

    private void paramCheck(HiDreamParam param) {
        if (null == param) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNullOrEmpty((String)param.getPrompt()) && (null == param.getImage() || param.getImage().isEmpty())) {
            throw new BusinessException("\u56fe\u7247\u63cf\u8ff0\u6216\u53c2\u8003\u56fe\u7247\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    private String buildParam(HiDreamParam param, String realUrl) {
        ImageHiDreamRequest request = new ImageHiDreamRequest();
        ImageHiDreamRequest.Header header = new ImageHiDreamRequest.Header();
        header.setAppId(this.appId);
        header.setStatus(this.status);
        header.setChannel("default");
        header.setCallbackUrl("default");
        request.setHeader(header);
        ImageHiDreamRequest.Parameter parameter = new ImageHiDreamRequest.Parameter(this);
        request.setParameter(parameter);
        ImageHiDreamRequest.Payload payload = new ImageHiDreamRequest.Payload(this);
        String text = Base64.getEncoder().encodeToString(StringUtils.gson.toJson((Object)param).getBytes(StandardCharsets.UTF_8));
        payload.getOig().setText(text);
        request.setPayload(payload);
        String json = StringUtils.gson.toJson((Object)request);
        logger.debug("HiDream\u56fe\u7247\u751f\u6210\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)realUrl, (Object)json);
        return json;
    }

    public static final class Builder
    extends PlatformBuilder<Builder> {
        private static final String HOST_URL = "https://cn-huadong-1.xf-yun.com/v1/private/s3fd61810/create";
        private String searchUrl = "https://cn-huadong-1.xf-yun.com/v1/private/s3fd61810/query";
        private static final String SERVICE_ID = "s3fd61810";

        public Builder(String appId, String apiKey, String apiSecret) {
            super(HOST_URL, SERVICE_ID, appId, apiKey, apiSecret);
            this.readTimeout(60);
        }

        public HiDreamClient build() {
            return new HiDreamClient(this);
        }

        public Builder searchUrl(String searchUrl) {
            this.searchUrl = searchUrl;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            super.hostUrl(hostUrl);
            return this;
        }
    }
}

