/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.sparkiat;

import cn.xfyun.model.sparkiat.response.SparkIatResponse;
import cn.xfyun.util.StringUtils;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSparkIatWebSocketListener
extends WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSparkIatWebSocketListener.class);

    public abstract void onSuccess(WebSocket var1, SparkIatResponse var2);

    public abstract void onFail(WebSocket var1, Throwable var2, Response var3);

    public abstract void onClose(WebSocket var1, int var2, String var3);

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        logger.info("webSocket is open");
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        try {
            if (text != null) {
                SparkIatResponse sparkIatResponse = (SparkIatResponse)StringUtils.gson.fromJson(text, SparkIatResponse.class);
                if (sparkIatResponse != null) {
                    this.onSuccess(webSocket, sparkIatResponse);
                } else {
                    this.onSuccess(webSocket, new SparkIatResponse(-1, "iat response error"));
                }
            }
        }
        catch (Exception e) {
            logger.error("parse text to object fail ,text is [{}]", (Object)text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
        logger.warn("webSocket is closing ,code is {} , reason is [{}]", (Object)code, (Object)reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        logger.warn("webSocket is closed ,code is {} , reason is [{}]", (Object)code, (Object)reason);
        this.onClose(webSocket, code, reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        super.onFailure(webSocket, t, response);
        logger.error("webSocket connect failed .", t);
        this.onFail(webSocket, t, response);
        if (response != null) {
            response.close();
        }
    }
}

