/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.websocket.AbstractClient;
import cn.xfyun.config.SparkModel;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.sparkmodel.FunctionCall;
import cn.xfyun.model.sparkmodel.SparkChatParam;
import cn.xfyun.model.sparkmodel.WebSearch;
import cn.xfyun.model.sparkmodel.request.SparkChatPostRequest;
import cn.xfyun.model.sparkmodel.request.SparkChatRequest;
import cn.xfyun.util.OkHttpUtils;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkChatClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(SparkChatClient.class);
    private final SparkModel sparkModel;
    private final float temperature;
    private final int maxTokens;
    private final int topK;
    private final WebSearch webSearch;
    private final List<FunctionCall> functions;
    private final int topP;
    private final float presencePenalty;
    private final float frequencyPenalty;
    private final boolean toolCallsSwitch;
    private final Object toolChoice;
    private final String responseType;
    private final List<String> suppressPlugin;
    private final boolean keepAlive;

    public SparkChatClient(Builder builder) {
        this.okHttpClient = builder.okHttpClient != null ? builder.okHttpClient : OkHttpUtils.client.newBuilder().connectTimeout((long)builder.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeout, TimeUnit.MILLISECONDS).callTimeout((long)builder.callTimeout, TimeUnit.MILLISECONDS).pingInterval((long)builder.pingInterval, TimeUnit.MILLISECONDS).retryOnConnectionFailure(builder.retryOnConnectionFailure).build();
        this.appId = builder.appId;
        this.apiKey = builder.apiKey;
        this.apiSecret = builder.apiSecret;
        this.originHostUrl = builder.hostUrl;
        this.sparkModel = builder.sparkModel;
        this.temperature = builder.temperature;
        this.maxTokens = builder.maxTokens;
        this.topK = builder.topK;
        this.webSearch = builder.webSearch;
        this.functions = builder.functions;
        this.topP = builder.topP;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.toolCallsSwitch = builder.toolCallsSwitch;
        this.toolChoice = builder.toolChoice;
        this.responseType = builder.responseType;
        this.suppressPlugin = builder.suppressPlugin;
        this.keepAlive = builder.keepAlive;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public List<String> getSuppressPlugin() {
        return this.suppressPlugin;
    }

    public Integer getTopP() {
        return this.topP;
    }

    public Float getPresencePenalty() {
        return Float.valueOf(this.presencePenalty);
    }

    public Float getFrequencyPenalty() {
        return Float.valueOf(this.frequencyPenalty);
    }

    public Boolean getToolCallsSwitch() {
        return this.toolCallsSwitch;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public SparkModel getSparkModel() {
        return this.sparkModel;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getTopK() {
        return this.topK;
    }

    public WebSearch getWebSearch() {
        return this.webSearch;
    }

    public List<FunctionCall> getFunctions() {
        return this.functions;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void send(SparkChatParam param, WebSocketListener webSocketListener) throws MalformedURLException, SignatureException {
        this.paramCheck(param, false);
        WebSocket socket = this.newWebSocket(webSocketListener);
        try {
            String body = this.buildParam(param);
            logger.debug("\u661f\u706b\u6587\u672c\u5927\u6a21\u578bws\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)body);
            socket.send(body);
        }
        catch (Exception e) {
            logger.error("ws\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public String send(SparkChatParam param) throws IOException {
        this.paramCheck(param, true);
        String body = this.buildPostParam(param, false);
        logger.debug("{}post\u8bf7\u6c42URL\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.sparkModel.getDesc(), this.originHostUrl, body});
        Request requestUrl = this.getRequest(body, false);
        try (Response response = this.okHttpClient.newCall(requestUrl).execute();){
            String string = Objects.requireNonNull(response.body(), this.sparkModel.getDesc() + "post\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a").string();
            return string;
        }
    }

    public void send(SparkChatParam param, Callback callback) {
        this.paramCheck(param, true);
        String body = this.buildPostParam(param, true);
        logger.debug("{}post\u8bf7\u6c42URL\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.sparkModel.getDesc(), this.originHostUrl, body});
        Request sseRequest = this.getRequest(body, true);
        this.okHttpClient.newCall(sseRequest).enqueue(callback);
    }

    private void paramCheck(SparkChatParam param, boolean isPost) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getMessages() == null || param.getMessages().isEmpty()) {
            throw new BusinessException("\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sparkModel == SparkModel.CHAT_MULTILANG && isPost) {
            throw new BusinessException(this.sparkModel.getDesc() + "\u6682\u4e0d\u652f\u6301post\u8bf7\u6c42");
        }
        if (null != param.getWebSearch() && param.getWebSearch().isEnable() && !this.sparkModel.isWebSearchEnable()) {
            throw new BusinessException(this.sparkModel.getDesc() + "\u6682\u4e0d\u652f\u6301\u8054\u7f51\u641c\u7d22");
        }
        if (null != param.getFunctions() && !this.sparkModel.isFunctionEnable()) {
            throw new BusinessException(this.sparkModel.getDesc() + "\u6682\u4e0d\u652f\u6301function\u8c03\u7528");
        }
    }

    private Request getRequest(String body, boolean isStream) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.originHostUrl), "\u8bf7\u6c42\u5730\u5740\u9519\u8bef\uff1a" + this.originHostUrl).newBuilder();
        Request.Builder builder = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)body));
        builder.addHeader("Authorization", "Bearer " + this.apiKey);
        builder.addHeader("Content-type", "application/json");
        if (isStream) {
            builder.addHeader("Accept", "text/event-stream");
        }
        return builder.build();
    }

    private String buildPostParam(SparkChatParam param, boolean stream) {
        List<FunctionCall> functions;
        SparkChatPostRequest sendRequest = new SparkChatPostRequest(this);
        sendRequest.setModel(this.sparkModel.getDomain());
        sendRequest.setStream(stream);
        sendRequest.setUser(param.getUserId());
        sendRequest.setMessages(param.getMessages());
        sendRequest.setTopP(this.topP);
        sendRequest.setPresencePenalty(Float.valueOf(this.presencePenalty));
        sendRequest.setFrequencyPenalty(Float.valueOf(this.frequencyPenalty));
        sendRequest.setToolCallsSwitch(this.toolCallsSwitch);
        sendRequest.setToolChoice(this.toolChoice);
        sendRequest.setSuppressPlugin(this.suppressPlugin);
        if (SparkModel.SPARK_X1 == this.sparkModel) {
            sendRequest.setKeepAlive(this.keepAlive);
        }
        ArrayList<Object> toolList = new ArrayList<Object>();
        WebSearch webSearch = param.getWebSearch();
        WebSearch webSearch2 = webSearch = null != webSearch ? webSearch : this.webSearch;
        if (null != webSearch) {
            JsonObject tool = new JsonObject();
            tool.addProperty("type", "web_search");
            tool.add("web_search", StringUtils.gson.toJsonTree((Object)webSearch));
            toolList.add(tool);
        }
        List<FunctionCall> list = functions = null != (functions = param.getFunctions()) && !functions.isEmpty() ? functions : this.functions;
        if (null != functions && !functions.isEmpty()) {
            functions.forEach(fun -> {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", "function");
                obj.add("function", StringUtils.gson.toJsonTree(fun));
                toolList.add(obj);
            });
        }
        if (!toolList.isEmpty()) {
            sendRequest.setTools(toolList);
        }
        if (!StringUtils.isNullOrEmpty((String)this.responseType)) {
            sendRequest.setResponseFormat(new SparkChatPostRequest.ResponseFormat());
        }
        return StringUtils.gson.toJson((Object)sendRequest);
    }

    private String buildParam(SparkChatParam param) {
        WebSearch webSearch;
        SparkChatRequest sendRequest = new SparkChatRequest();
        String userId = param.getUserId();
        if (null == userId) {
            userId = UUID.randomUUID().toString().substring(0, 10);
        }
        SparkChatRequest.Header header = new SparkChatRequest.Header(this.appId, userId);
        sendRequest.setHeader(header);
        SparkChatRequest.Parameter parameter = new SparkChatRequest.Parameter();
        SparkChatRequest.Parameter.Chat chat = new SparkChatRequest.Parameter.Chat();
        chat.setDomain(this.sparkModel.getDomain());
        chat.setTemperature(Float.valueOf(this.temperature));
        chat.setMaxTokens(this.maxTokens);
        chat.setTopK(this.topK);
        if (SparkModel.SPARK_X1 == this.sparkModel) {
            chat.setTopP(this.topP);
            chat.setFrequencyPenalty(Float.valueOf(this.frequencyPenalty));
            chat.setPresencePenalty(Float.valueOf(this.presencePenalty));
        }
        WebSearch webSearch2 = webSearch = null != (webSearch = param.getWebSearch()) ? webSearch : this.webSearch;
        if (null != webSearch && this.sparkModel.isWebSearchEnable()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "web_search");
            obj.add("web_search", StringUtils.gson.toJsonTree((Object)webSearch));
            chat.setTools(Collections.singletonList(obj));
        }
        chat.setChatId(param.getChatId());
        parameter.setChat(chat);
        sendRequest.setParameter(parameter);
        List<FunctionCall> functions = param.getFunctions();
        functions = null != functions && !functions.isEmpty() ? functions : this.functions;
        SparkChatRequest.Payload payload = new SparkChatRequest.Payload();
        SparkChatRequest.Payload.Message message = new SparkChatRequest.Payload.Message();
        message.setText(param.getMessages());
        if (null != functions && !functions.isEmpty() && this.sparkModel.isFunctionEnable()) {
            SparkChatRequest.Payload.Function function = new SparkChatRequest.Payload.Function();
            function.setText(functions);
            payload.setFunctions(function);
        }
        payload.setMessage(message);
        sendRequest.setPayload(payload);
        return StringUtils.gson.toJson((Object)sendRequest);
    }

    public static final class Builder {
        public final String SPARK_X1_URL = "https://spark-api-open.xf-yun.com/v2/chat/completions";
        public final String SPARK_URL = "https://spark-api-open.xf-yun.com/v1/chat/completions";
        private boolean retryOnConnectionFailure = true;
        private int callTimeout = 0;
        private int connectTimeout = 30000;
        private int readTimeout = 60000;
        private int writeTimeout = 30000;
        private int pingInterval = 0;
        private String appId;
        private String apiKey;
        private String apiSecret;
        private SparkModel sparkModel;
        private String hostUrl = "https://spark-api-open.xf-yun.com/v1/chat/completions";
        private float temperature = 0.5f;
        private int maxTokens = 4096;
        private int topK = 4;
        private WebSearch webSearch;
        private List<FunctionCall> functions;
        private int topP = 1;
        private float presencePenalty = 0.0f;
        private float frequencyPenalty = 0.0f;
        private boolean toolCallsSwitch = false;
        private Object toolChoice;
        private String responseType;
        private List<String> suppressPlugin;
        private boolean keepAlive = false;
        private OkHttpClient okHttpClient;

        public SparkChatClient build() {
            return new SparkChatClient(this);
        }

        public Builder signatureWs(String appId, String apiKey, String apiSecret, SparkModel model) {
            this.appId = appId;
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
            this.sparkModel = model;
            this.hostUrl = model.getUrl();
            if (SparkModel.SPARK_X1 == model) {
                this.temperature = 1.2f;
                this.frequencyPenalty = 0.001f;
                this.presencePenalty = 2.01f;
            }
            return this;
        }

        public Builder signatureHttp(String apiPassword, SparkModel model) {
            this.apiKey = apiPassword;
            this.sparkModel = model;
            this.temperature = 1.0f;
            if (SparkModel.SPARK_X1 == model) {
                this.temperature = 1.2f;
                this.frequencyPenalty = 0.001f;
                this.presencePenalty = 2.01f;
                this.hostUrl = "https://spark-api-open.xf-yun.com/v2/chat/completions";
            }
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder topK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder webSearch(WebSearch webSearch) {
            this.webSearch = webSearch;
            return this;
        }

        public Builder functions(List<FunctionCall> functions) {
            this.functions = functions;
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder topP(int topP) {
            this.topP = topP;
            return this;
        }

        public Builder presencePenalty(float presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(float frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder toolCallsSwitch(boolean toolCallsSwitch) {
            this.toolCallsSwitch = toolCallsSwitch;
            return this;
        }

        public Builder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        public Builder suppressPlugin(List<String> suppressPlugin) {
            this.suppressPlugin = suppressPlugin;
            return this;
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }
    }
}

