/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.AIPPTEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.model.aippt.request.PPTCreate;
import cn.xfyun.model.aippt.request.PPTSearch;
import cn.xfyun.model.sign.Signature;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIPPTV2Client
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AIPPTV2Client.class);

    public AIPPTV2Client(Builder builder) {
        super((HttpBuilder)builder);
    }

    public String list(PPTSearch pptSearch) throws IOException {
        this.nullCheck(pptSearch);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)pptSearch.toJSONString());
        return this.send(AIPPTEnum.LIST, body, new Object[0]);
    }

    public String create(PPTCreate pptCreate) throws IOException {
        this.nullCheck(pptCreate);
        pptCreate.createCheck();
        return this.send(AIPPTEnum.CREATE, pptCreate.toFormDataBody(), new Object[0]);
    }

    public String createOutline(PPTCreate pptCreate) throws IOException {
        this.nullCheck(pptCreate);
        pptCreate.createOutLineCheck();
        return this.send(AIPPTEnum.CREATE_OUTLINE, pptCreate.toFormDataBody(), new Object[0]);
    }

    public String createOutlineByDoc(PPTCreate pptCreate) throws IOException {
        this.nullCheck(pptCreate);
        pptCreate.createOutlineByDocCheck();
        return this.send(AIPPTEnum.CREATE_OUTLINE_BY_DOC, pptCreate.toFormDataBody(), new Object[0]);
    }

    public String createPptByOutline(PPTCreate pptCreate) throws IOException {
        this.nullCheck(pptCreate);
        pptCreate.createPptByOutlineCheck();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)pptCreate.toJSONString());
        return this.send(AIPPTEnum.CREATE_PPT_BY_OUTLINE, body, new Object[0]);
    }

    public String progress(String sid) throws IOException {
        return this.send(AIPPTEnum.PROGRESS, null, sid);
    }

    private void nullCheck(Object param) {
        if (param == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String send(AIPPTEnum aipptEnum, RequestBody body, Object ... param) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(6);
        Long timestamp = System.currentTimeMillis() / 1000L;
        String signature = Signature.generateSignature((String)this.appId, (Long)timestamp, (String)this.apiSecret);
        header.put("signature", signature);
        header.put("appId", this.appId);
        header.put("timestamp", String.valueOf(timestamp));
        String url = aipptEnum.getUrl();
        if (param != null) {
            url = String.format(aipptEnum.getUrl(), param);
        }
        logger.debug("{}\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{aipptEnum.getDesc(), url, null == body ? "" : body.toString()});
        return this.sendRequest(url, aipptEnum.getMethod(), header, body);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://zwapi.xfyun.cn/";

        public Builder(String appId, String apiSecret) {
            super(HOST_URL, appId, null, apiSecret);
            this.readTimeout(120);
        }

        public AIPPTV2Client build() {
            return new AIPPTV2Client(this);
        }
    }
}

