/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WatermarkVerificationClient
extends HttpClient {
    private boolean autoRotate;

    public WatermarkVerificationClient(Builder builder) {
        super((HttpBuilder)builder);
        this.autoRotate = builder.autoRotate;
    }

    public String compare(String faceImageBase64, String watermarkImageBase64) throws IOException {
        JsonObject jso = new JsonObject();
        jso.addProperty("get_image", Boolean.valueOf(true));
        jso.addProperty("auto_rotate", Boolean.valueOf(this.autoRotate));
        String params = jso.toString();
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)params);
        HashMap<String, String> body = new HashMap<String, String>(2);
        body.put("face_image", faceImageBase64);
        body.put("watermark_image", watermarkImageBase64);
        return this.sendPost(this.hostUrl, header, body);
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://api.xfyun.cn/v1/service/v1/image_identify/watermark_verification";
        private boolean autoRotate = false;

        public Builder(String appId, String apiKey) {
            super(HOST_URL, appId, apiKey, null);
        }

        public Builder autoRotate(boolean autoRotate) {
            this.autoRotate = autoRotate;
            return this;
        }

        public WatermarkVerificationClient build() {
            WatermarkVerificationClient client = new WatermarkVerificationClient(this);
            return client;
        }
    }
}

