/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;

public class FaceVerificationClient
extends HttpClient {
    private boolean autoRotate;

    public boolean isAutoRotate() {
        return this.autoRotate;
    }

    public FaceVerificationClient(Builder builder) {
        super((HttpBuilder)builder);
        this.autoRotate = builder.autoRotate;
    }

    public String compareFace(String imageBase641, String imageBase642) throws IOException {
        JsonObject jso = new JsonObject();
        jso.addProperty("get_image", Boolean.valueOf(true));
        jso.addProperty("auto_rotate", Boolean.valueOf(this.autoRotate));
        String params = jso.toString();
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)params);
        return this.sendPost(this.hostUrl, FORM, header, "first_image=" + URLEncoder.encode(imageBase641, "UTF-8") + "&second_image=" + URLEncoder.encode(imageBase642, "UTF-8"));
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://api.xfyun.cn/v1/service/v1/image_identify/face_verification";
        private boolean autoRotate = false;

        public Builder(String appId, String apiKey) {
            super(HOST_URL, appId, apiKey, null);
        }

        public Builder url(String url) {
            this.hostUrl(url);
            return this;
        }

        public Builder autoRotate(boolean autoRotate) {
            this.autoRotate = autoRotate;
            return this;
        }

        public FaceVerificationClient build() {
            FaceVerificationClient client = new FaceVerificationClient(this);
            return client;
        }
    }
}

