/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.struct.query;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.Distinct;
import db.sql.api.cmd.struct.query.ISelect;
import db.sql.api.impl.cmd.dbFun.Count;
import db.sql.api.impl.cmd.dbFun.Function;
import db.sql.api.impl.tookit.Lists;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Select
implements ISelect<Select> {
    private final List<Cmd> selectFields = new ArrayList<Cmd>(6);
    private boolean distinct = false;
    private Integer top;

    public List<Cmd> getSelectField() {
        return this.selectFields;
    }

    public Select selectIgnore(Cmd column) {
        this.selectFields.remove(column);
        return this;
    }

    public Select top(int count) {
        this.top = count;
        return this;
    }

    public Select distinct() {
        this.distinct = true;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Select select(Cmd field) {
        this.selectFields.add(field);
        return this;
    }

    public Select select(Cmd ... fields) {
        Lists.merge(this.selectFields, fields);
        return this;
    }

    public Select select(List<Cmd> fields) {
        this.selectFields.addAll(fields);
        return this;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (!(parent instanceof Function)) {
            sqlBuilder.append(SqlConst.SELECT);
        }
        if (Objects.nonNull(this.top) && context.getDbType() == DbType.SQL_SERVER) {
            sqlBuilder.append(" TOP ").append(this.top).append(SqlConst.BLANK);
        }
        if (this.distinct) {
            Distinct.INSTANCE.sql(module, (Cmd)this, context, sqlBuilder);
            if ((context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.OPEN_GAUSS || context.getDbType() == DbType.H2) && parent instanceof Count) {
                sqlBuilder.append(SqlConst.BRACKET_LEFT);
            }
        }
        sqlBuilder = CmdUtils.join((Cmd)this, (Cmd)this, (SqlBuilderContext)context, (StringBuilder)sqlBuilder, this.getSelectField(), (char[])SqlConst.DELIMITER);
        if (this.distinct && (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.OPEN_GAUSS || context.getDbType() == DbType.H2) && parent instanceof Count) {
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.selectFields);
    }
}

