/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.struct.insert;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.struct.insert.IInsertValues;
import db.sql.api.impl.cmd.executor.AbstractInsert;
import db.sql.api.impl.tookit.Objects;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.util.ArrayList;
import java.util.List;

public class InsertValues
implements IInsertValues<Cmd> {
    protected List<List<Cmd>> values;

    public List<List<Cmd>> getValues() {
        return this.values;
    }

    public InsertValues add(List<Cmd> values) {
        if (this.values == null) {
            this.values = new ArrayList<List<Cmd>>(10);
        }
        this.values.add(values);
        return this;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        List<List<Cmd>> insertValues;
        if (Objects.isNull(this.values) || this.values.isEmpty()) {
            return sqlBuilder;
        }
        boolean oracleMuti = false;
        if (context.getDbType() == DbType.ORACLE && parent instanceof AbstractInsert && Objects.nonNull(insertValues = this.getValues()) && insertValues.size() > 1) {
            oracleMuti = true;
        }
        if (!oracleMuti) {
            sqlBuilder.append(SqlConst.VALUES);
        }
        boolean isFirstLine = true;
        for (List<Cmd> values : this.values) {
            if (!isFirstLine) {
                if (oracleMuti) {
                    sqlBuilder.append(SqlConst.UNION_ALL);
                } else {
                    sqlBuilder.append(SqlConst.DELIMITER);
                }
            }
            if (!oracleMuti) {
                sqlBuilder.append(SqlConst.BLANK).append(SqlConst.BRACKET_LEFT);
            } else {
                sqlBuilder.append(SqlConst.BLANK).append(SqlConst.SELECT);
            }
            boolean isFirst = true;
            for (Cmd value : values) {
                if (!isFirst) {
                    sqlBuilder.append(SqlConst.DELIMITER);
                }
                value.sql(module, (Cmd)this, context, sqlBuilder);
                isFirst = false;
            }
            if (!oracleMuti) {
                sqlBuilder.append(SqlConst.BRACKET_RIGHT).append(SqlConst.BLANK);
            } else {
                sqlBuilder.append(SqlConst.BLANK).append(SqlConst.FROM_DUAL);
            }
            isFirstLine = false;
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.values);
    }
}

