/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.struct;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.JoinMode;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.struct.IJoin;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.cmd.struct.On;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.util.function.Function;

public class Join
implements IJoin<Join, On, Table, TableField, Cmd, Object, ConditionChain> {
    private final IDataset mainTable;
    private final IDataset secondTable;
    private final JoinMode mode;
    private final On on;

    public Join(JoinMode mode, IDataset mainTable, IDataset secondTable, Function<Join, On> onFunction) {
        this.mode = mode;
        this.mainTable = mainTable;
        this.secondTable = secondTable;
        this.on = onFunction != null ? onFunction.apply(this) : null;
    }

    public IDataset getMainTable() {
        return this.mainTable;
    }

    public IDataset getSecondTable() {
        return this.secondTable;
    }

    public JoinMode getMode() {
        return this.mode;
    }

    public On getOn() {
        return this.on;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(SqlConst.BLANK).append(this.mode.getSql());
        this.getSecondTable().sql(module, (Cmd)this, context, sqlBuilder);
        if (this.on != null) {
            this.getOn().sql(module, (Cmd)this, context, sqlBuilder);
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, (Object[])new Object[]{this.mainTable, this.secondTable, this.on});
    }
}

