/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.GetterField;
import db.sql.api.cmd.JoinMode;
import db.sql.api.cmd.UpdateStrategy;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.cmd.executor.IUpdate;
import db.sql.api.cmd.struct.IJoin;
import db.sql.api.cmd.struct.IOn;
import db.sql.api.cmd.struct.Joins;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.BaseExecutor;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.cmd.struct.From;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.cmd.struct.On;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.cmd.struct.query.Returning;
import db.sql.api.impl.cmd.struct.update.UpdateSets;
import db.sql.api.impl.cmd.struct.update.UpdateTable;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractUpdate<SELF extends AbstractUpdate<SELF, CMD_FACTORY>, CMD_FACTORY extends CmdFactory>
extends BaseExecutor<SELF, CMD_FACTORY>
implements IUpdate<SELF, Table, TableField, Cmd, Object, ConditionChain, UpdateTable, From, Join, On, Where, Returning> {
    protected final ConditionFactory conditionFactory;
    protected final CMD_FACTORY $;
    protected UpdateTable updateTable;
    protected From from;
    protected UpdateSets updateSets;
    protected Where where;
    protected Joins joins;
    protected Returning returning;

    public AbstractUpdate(CMD_FACTORY $) {
        this.$ = $;
        this.conditionFactory = ((CmdFactory)$).createConditionFactory();
    }

    public AbstractUpdate(Where where) {
        this.$ = where.getConditionFactory().getCmdFactory();
        this.conditionFactory = where.getConditionFactory();
        this.where = where;
        this.append((Cmd)where);
    }

    public <T> TableField $(Getter<T> getter) {
        return this.$(getter, 1);
    }

    public <T> TableField $(Getter<T> getter, int storey) {
        return ((CmdFactory)this.$()).field((Getter)getter, storey);
    }

    public Table $(Class entityType) {
        return this.$(entityType, 1);
    }

    public Table $(Class entityType, int storey) {
        return ((CmdFactory)this.$()).table(entityType, storey);
    }

    public TableField $(Class entityType, String fieldName) {
        return this.$(entityType, fieldName, 1);
    }

    public TableField $(Class entityType, String fieldName, int storey) {
        return ((CmdFactory)this.$()).field(entityType, fieldName, storey);
    }

    @Override
    public CMD_FACTORY $() {
        return this.$;
    }

    @Override
    protected void initCmdSorts(Map<Class<? extends Cmd>, Integer> cmdSorts) {
        int i = 0;
        cmdSorts.put(UpdateTable.class, i += 10);
        cmdSorts.put(UpdateSets.class, i += 10);
        cmdSorts.put(From.class, i += 10);
        cmdSorts.put(Joins.class, i += 10);
        cmdSorts.put(Where.class, i += 10);
        cmdSorts.put(Returning.class, i += 10);
    }

    public UpdateTable $update(Table ... tables) {
        if (this.updateTable == null) {
            this.updateTable = new UpdateTable(tables);
            this.append((Cmd)this.updateTable);
        }
        for (Table table : tables) {
            this.getSQLListeners().stream().forEach(item -> item.onUpdate((Object)this, (IDataset)table));
        }
        return this.updateTable;
    }

    public SELF update(Class entity, Consumer<Table> consumer) {
        Table table = (Table)this.$.table(entity);
        this.update(new Table[]{table});
        return (SELF)this;
    }

    public SELF update(Class ... entities) {
        ITable[] tables = new Table[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            Class entity = entities[i];
            tables[i] = (Table)this.$.table(entity);
        }
        return (SELF)((AbstractUpdate)this.update(tables));
    }

    public SELF set(TableField field, Object value) {
        value = field.paramWrap(value);
        Cmd v = Methods.cmd(value);
        if (this.updateSets == null) {
            this.updateSets = new UpdateSets();
            this.append((Cmd)this.updateSets);
        }
        this.updateSets.set(field, v);
        return (SELF)this;
    }

    public <T> SELF set(boolean when, Getter<T> field, Object value) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)this.set((Getter)field, value);
    }

    public <T, V extends Serializable> SELF set(Getter<T> field, V value, Predicate<V> predicate) {
        return this.set(predicate.test(value), field, value);
    }

    public <T> SELF set(Getter<T> field, Object value) {
        if (value instanceof Getter) {
            return this.set((TableField)this.$.field(field), (Object)this.$.field((Getter)value));
        }
        return (SELF)((AbstractUpdate)super.set(field, value));
    }

    public <T, T2> SELF set(Getter<T> field, Getter<T2> targetField, BiFunction<TableField, TableField, Object> f) {
        return (SELF)((AbstractUpdate)super.set(field, f.apply((TableField)this.$.field(field), (TableField)this.$.field(targetField))));
    }

    public <T, T2> SELF set(boolean when, Getter<T> field, Getter<T2> targetField, BiFunction<TableField, TableField, Object> f) {
        if (!when) {
            return (SELF)this;
        }
        return this.set(field, targetField, f);
    }

    public <T> SELF set(Getter<T> field, GetterField[] targetFields, Function<TableField[], Cmd> f) {
        return (SELF)((AbstractUpdate)super.set(field, (Object)f.apply(((CmdFactory)this.$).fields(targetFields))));
    }

    public <T> SELF set(boolean when, Getter<T> field, GetterField[] targetField, Function<TableField[], Cmd> f) {
        if (!when) {
            return (SELF)this;
        }
        return this.set(field, targetField, f);
    }

    public <T> SELF set(Getter<T> field, Object value, UpdateStrategy updateStrategy) {
        if (Objects.isNull(value)) {
            if (updateStrategy == UpdateStrategy.THROW_EXCEPTION) {
                throw new NullPointerException();
            }
            if (updateStrategy == UpdateStrategy.NULL_TO_NULL) {
                return this.set((TableField)this.$.field(field), (Object)NULL.NULL);
            }
            if (updateStrategy == UpdateStrategy.NULL_IGNORE) {
                return (SELF)this;
            }
            throw new RuntimeException("not support update strategy");
        }
        return this.set((TableField)this.$.field(field), value);
    }

    public SELF set(TableField field, Object value, UpdateStrategy updateStrategy) {
        if (Objects.isNull(value)) {
            if (updateStrategy == UpdateStrategy.THROW_EXCEPTION) {
                throw new NullPointerException();
            }
            if (updateStrategy == UpdateStrategy.NULL_TO_NULL) {
                return this.set(field, (Object)NULL.NULL);
            }
            if (updateStrategy == UpdateStrategy.NULL_IGNORE) {
                return (SELF)this;
            }
            throw new RuntimeException("not support update strategy");
        }
        return this.set(field, value);
    }

    public <T> SELF set(Getter<T> field, Function<TableField, Cmd> f) {
        TableField tableField = (TableField)this.$.field(field);
        return this.set(tableField, (Object)f.apply(tableField));
    }

    public Join $join(JoinMode mode, IDataset<?, ?> mainTable, IDataset<?, ?> secondTable, Consumer<On> onConsumer) {
        Join join = new Join(mode, mainTable, secondTable, joinDataset -> new On(this.conditionFactory, (Join)joinDataset));
        if (Objects.isNull(this.joins)) {
            this.joins = new Joins();
            this.append((Cmd)this.joins);
        }
        this.joins.add((IJoin)join);
        if (Objects.nonNull(onConsumer)) {
            onConsumer.accept(join.getOn());
        }
        this.getSQLListeners().stream().forEach(item -> item.onJoin((Object)this, mode, mainTable, secondTable, (IOn)join.getOn()));
        return join;
    }

    public SELF join(JoinMode mode, Class<?> mainTable, int mainTableStorey, Class<?> secondTable, int secondTableStorey, Consumer<On> consumer) {
        return this.join(mode, (IDataset<?, ?>)((CmdFactory)this.$).table((Class)mainTable, mainTableStorey), (IDataset<?, ?>)((CmdFactory)this.$).table((Class)secondTable, secondTableStorey), consumer);
    }

    public SELF join(JoinMode mode, Class<?> mainTable, int mainTableStorey, IDataset<?, ?> secondTable, Consumer<On> consumer) {
        return this.join(mode, (IDataset<?, ?>)((CmdFactory)this.$).table((Class)mainTable, mainTableStorey), secondTable, consumer);
    }

    public SELF returning(Cmd column) {
        this.$returning().returning(column);
        return (SELF)this;
    }

    public <T> SELF returning(int storey, Getter<T> ... columns) {
        this.$returning().returning(((CmdFactory)this.$).fields(storey, columns));
        return (SELF)this;
    }

    public <T> SELF returning(Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (f != null) {
            this.$returning().returning(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey)));
        } else {
            this.$returning().returning((Cmd)((CmdFactory)this.$).field((Getter)column, storey));
        }
        return (SELF)this;
    }

    public <T> SELF returningIgnore(Getter<T> column, int storey) {
        this.$returning().returningIgnore((Cmd)((CmdFactory)this.$).field((Getter)column, storey));
        return (SELF)this;
    }

    public Where $where() {
        if (this.where == null) {
            this.where = new Where(this.conditionFactory);
            this.append((Cmd)this.where);
        }
        return this.where;
    }

    public Returning $returning() {
        if (this.returning == null) {
            this.returning = new Returning();
            this.append((Cmd)this.returning);
        }
        return this.returning;
    }

    public SELF returning(Class entity, int storey) {
        this.returning((Cmd)((CmdFactory)this.$()).allField(((CmdFactory)this.$()).table(entity, storey)));
        return (SELF)this;
    }

    public <T> SELF and(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().and(column, storey, f);
        return (SELF)this;
    }

    public <T> SELF or(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().or(column, storey, f);
        return (SELF)this;
    }

    public From $from(IDataset table) {
        if (this.from == null) {
            this.from = new From();
            this.append((Cmd)this.from);
        }
        this.from.append(table);
        this.getSQLListeners().stream().forEach(item -> item.onFrom((Object)this, table));
        return this.from;
    }

    public SELF from(Class entity, int storey, Consumer<Table> consumer) {
        ITable table = ((CmdFactory)this.$).table(entity, storey);
        this.from(new IDataset[]{table});
        if (Objects.nonNull(consumer)) {
            consumer.accept((Table)table);
        }
        return (SELF)this;
    }

    public SELF join(JoinMode mode, IDataset<?, ?> mainTable, Class<?> secondTable, Consumer<On> consumer) {
        this.$join(mode, (IDataset)mainTable, this.$(secondTable), (Consumer)consumer);
        return (SELF)this;
    }

    public SELF join(JoinMode mode, IDataset<?, ?> mainTable, IDataset<?, ?> secondTable, Consumer<On> consumer) {
        this.$join(mode, (IDataset)mainTable, (IDataset)secondTable, (Consumer)consumer);
        return (SELF)this;
    }

    public UpdateTable getUpdateTable() {
        return this.updateTable;
    }

    public UpdateSets getUpdateSets() {
        return this.updateSets;
    }

    public Joins getJoins() {
        return this.joins;
    }

    public Where getWhere() {
        return this.where;
    }

    public From getFrom() {
        return this.from;
    }

    public Returning getReturning() {
        return this.returning;
    }

    public StringBuilder sql(Cmd mould, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (Objects.nonNull(this.getJoins()) && (context.getDbType() == DbType.MYSQL || context.getDbType() == DbType.MARIA_DB || context.getDbType() == DbType.DM)) {
            this.cmdSorts().remove(Joins.class);
            this.cmdSorts().put(Joins.class, this.cmdSorts().get(UpdateTable.class) + 1);
        }
        return super.sql(mould, parent, context, sqlBuilder);
    }
}

