/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.dbFun;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.dbFun.BasicFunction;
import db.sql.api.impl.cmd.dbFun.TimeUnits;
import db.sql.api.impl.tookit.SqlConst;

public class DateAdd
extends BasicFunction<DateAdd> {
    private final int n;
    private final TimeUnits timeUnit;

    public DateAdd(Cmd key, int n, TimeUnits timeUnit) {
        super(SqlConst.DATE_ADD, key);
        this.n = n;
        this.timeUnit = timeUnit;
    }

    @Override
    public StringBuilder functionSql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (context.getDbType() == DbType.H2) {
            sqlBuilder.append("DATEADD").append(SqlConst.BRACKET_LEFT);
            sqlBuilder.append(this.timeUnit.name(), 0, this.timeUnit.name().length() - 1);
            sqlBuilder.append(SqlConst.DELIMITER);
            sqlBuilder.append(this.n);
            sqlBuilder.append(SqlConst.DELIMITER);
            sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        if (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.OPEN_GAUSS) {
            sqlBuilder.append(SqlConst.BRACKET_LEFT);
            sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append("+'");
            sqlBuilder.append(this.n);
            sqlBuilder.append(SqlConst.BLANK);
            sqlBuilder.append(this.timeUnit.name(), 0, this.timeUnit.name().length() - 1);
            sqlBuilder.append(SqlConst.SINGLE_QUOT);
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        if (context.getDbType() == DbType.DM || context.getDbType() == DbType.SQL_SERVER) {
            sqlBuilder.append("DATEADD").append(SqlConst.BRACKET_LEFT);
            sqlBuilder.append(this.timeUnit.name(), 0, this.timeUnit.name().length() - 1);
            sqlBuilder.append(SqlConst.DELIMITER);
            sqlBuilder.append(this.n);
            sqlBuilder.append(SqlConst.DELIMITER);
            sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        if (context.getDbType() == DbType.ORACLE || context.getDbType() == DbType.KING_BASE) {
            sqlBuilder.append(SqlConst.BRACKET_LEFT);
            sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append('+');
            sqlBuilder.append(SqlConst.INTERVAL).append(SqlConst.SINGLE_QUOT).append(this.n).append(SqlConst.SINGLE_QUOT);
            sqlBuilder.append(this.timeUnit.name(), 0, this.timeUnit.name().length() - 1);
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        if (context.getDbType() == DbType.DB2) {
            sqlBuilder.append(SqlConst.BRACKET_LEFT);
            sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append('+');
            sqlBuilder.append(this.n).append(SqlConst.BLANK);
            sqlBuilder.append(this.timeUnit.name());
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        if (context.getDbType() == DbType.SQLITE) {
            sqlBuilder.append("DATETIME");
            sqlBuilder.append(SqlConst.BRACKET_LEFT);
            sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append(SqlConst.DELIMITER);
            sqlBuilder.append(SqlConst.SINGLE_QUOT);
            sqlBuilder.append(this.n).append(SqlConst.BLANK);
            sqlBuilder.append(this.timeUnit.name());
            sqlBuilder.append(SqlConst.SINGLE_QUOT);
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        sqlBuilder.append(this.operator).append(SqlConst.BRACKET_LEFT);
        sqlBuilder = this.key.sql(module, (Cmd)this, context, sqlBuilder);
        sqlBuilder.append(SqlConst.DELIMITER).append(SqlConst.INTERVAL).append(this.n);
        sqlBuilder.append(SqlConst.BLANK);
        sqlBuilder.append(this.timeUnit.name(), 0, this.timeUnit.name().length() - 1);
        sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        return sqlBuilder;
    }
}

