/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.condition;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.LikeMode;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.condition.BasicCondition;
import db.sql.api.impl.tookit.Objects;
import db.sql.api.impl.tookit.SqlConst;

public class AbstractLike<T extends AbstractLike<T>>
extends BasicCondition<T> {
    private final LikeMode mode;

    public AbstractLike(char[] operator, LikeMode mode, Cmd key, Cmd value) {
        super(operator, key, value);
        this.mode = mode;
    }

    public LikeMode getMode() {
        return this.mode;
    }

    @Override
    public StringBuilder conditionSql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        BasicValue basicValue;
        sqlBuilder = this.getField().sql(module, (Cmd)this, context, sqlBuilder);
        sqlBuilder.append(this.getOperator());
        boolean before = false;
        boolean after = false;
        switch (this.mode) {
            case NONE: {
                break;
            }
            case DEFAULT: {
                before = true;
                after = true;
                break;
            }
            case RIGHT: {
                after = true;
                break;
            }
            default: {
                before = true;
            }
        }
        if (context.getDbType() == DbType.DB2 || context.getDbType() == DbType.SQLITE) {
            if (!before && !after) {
                sqlBuilder = this.getValue().sql(module, (Cmd)this, context, sqlBuilder);
            } else {
                sqlBuilder.append(SqlConst.BRACKET_LEFT);
                if (before) {
                    sqlBuilder.append(SqlConst.VAGUE_SYMBOL);
                    sqlBuilder.append(SqlConst.CONCAT_SPLIT_SYMBOL);
                }
                sqlBuilder = this.getValue().sql(module, (Cmd)this, context, sqlBuilder);
                if (after) {
                    sqlBuilder.append(SqlConst.CONCAT_SPLIT_SYMBOL).append(SqlConst.VAGUE_SYMBOL);
                }
                sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            }
            return sqlBuilder;
        }
        if (before && after && context.getDbType() == DbType.ORACLE) {
            sqlBuilder.append(SqlConst.BRACKET_LEFT);
            sqlBuilder.append(SqlConst.VAGUE_SYMBOL).append(SqlConst.CONCAT_SPLIT_SYMBOL);
            sqlBuilder = this.getValue().sql(module, (Cmd)this, context, sqlBuilder);
            sqlBuilder.append(SqlConst.CONCAT_SPLIT_SYMBOL).append(SqlConst.VAGUE_SYMBOL);
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        if (before || after) {
            sqlBuilder.append(SqlConst.CONCAT).append(SqlConst.BRACKET_LEFT);
        }
        if (before) {
            sqlBuilder.append(SqlConst.VAGUE_SYMBOL).append(SqlConst.DELIMITER);
        }
        sqlBuilder = this.getValue().sql(module, (Cmd)this, context, sqlBuilder);
        if (this.getValue().getClass() == BasicValue.class && (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.OPEN_GAUSS) && Objects.nonNull(basicValue = (BasicValue)this.getValue())) {
            sqlBuilder.append(SqlConst.CAST_TEXT);
        }
        if (after) {
            sqlBuilder.append(SqlConst.DELIMITER).append(SqlConst.VAGUE_SYMBOL);
        }
        if (before || after) {
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        }
        return sqlBuilder;
    }
}

