/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.impl.cmd.basic.AbstractDatasetField;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import db.sql.api.tookit.SqlInjectionUtils;
import java.util.Objects;

public class Column
extends AbstractDatasetField<Column> {
    public Column(String name) {
        this(null, name);
    }

    public Column(IDataset dataset, String name) {
        super(dataset, name);
        if (SqlInjectionUtils.check((String)name)) {
            throw new IllegalArgumentException("Column name may be not safe");
        }
    }

    @Override
    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(SqlConst.BLANK).append(this.getName(context.getDbType()));
        if (Objects.nonNull(this.alias) && parent instanceof Select) {
            sqlBuilder.append(SqlConst.BLANK).append(this.alias);
        }
        return sqlBuilder;
    }

    @Override
    public boolean contain(Cmd cmd) {
        IDataset dataset;
        boolean contain = false;
        if (Objects.nonNull(this.getTable())) {
            contain = CmdUtils.contain((Cmd)cmd, (Cmd)this.getTable());
        }
        if (!contain && cmd instanceof IDataset && (dataset = (IDataset)cmd).getAlias() != null && !dataset.getAlias().isEmpty()) {
            return this.getName().contains(dataset.getAlias() + ".");
        }
        return contain;
    }
}

