/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.impl.cmd.basic.AbstractAlias;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class BaseTemplate<T extends BaseTemplate<T>>
extends AbstractAlias<T>
implements Cmd {
    protected final String template;
    protected final Cmd[] params;
    protected final boolean wrapping;

    public BaseTemplate(String template, Object ... params) {
        this(false, template, params);
    }

    public BaseTemplate(boolean wrapping, String template, Object ... params) {
        this.template = template;
        if (Objects.nonNull(params)) {
            Cmd[] cmds = new Cmd[params.length];
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                cmds[i] = param instanceof Cmd ? (Cmd)param : new BasicValue(param);
            }
            this.params = cmds;
        } else {
            this.params = null;
        }
        this.wrapping = wrapping;
    }

    public BaseTemplate(boolean wrapping, String template, Cmd ... params) {
        this.template = template;
        this.wrapping = wrapping;
        this.params = params;
    }

    protected String wrapTemplate(String template) {
        StringBuilder tsb = new StringBuilder();
        for (int i = 0; i < template.length(); ++i) {
            boolean hasPre = i > 0;
            boolean hasNext = i < template.length() - 1;
            System.out.println(i);
            char c = template.charAt(i);
            if (c != '\'') {
                tsb.append(c);
                continue;
            }
            boolean doAppend = false;
            if (hasPre && hasNext) {
                if (template.charAt(i - 1) != '\'' && template.charAt(i + 1) != '\'') {
                    doAppend = true;
                }
            } else if (hasPre) {
                if (template.charAt(i - 1) != '\'') {
                    doAppend = true;
                }
            } else if (hasNext && template.charAt(i + 1) != '\'') {
                doAppend = true;
            }
            if (doAppend) {
                tsb.append('\'');
            }
            tsb.append(c);
        }
        return tsb.toString();
    }

    private void appendAlias(Cmd module, Cmd user, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (module instanceof Select && user instanceof Select && this.getAlias() != null) {
            sqlBuilder.append(SqlConst.AS(context.getDbType()));
            sqlBuilder.append(this.getAlias());
        }
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(SqlConst.BLANK);
        String str = this.template;
        if (Objects.nonNull(this.params) && this.params.length > 0) {
            Object[] paramsStr = new Object[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                paramsStr[i] = this.params[i].sql(module, (Cmd)this, context, new StringBuilder());
            }
            if (this.wrapping) {
                str = this.wrapTemplate(this.template);
            }
            str = MessageFormat.format(str, paramsStr);
        } else if (this.wrapping) {
            str = this.wrapTemplate(this.template);
            str = MessageFormat.format(str, null);
        }
        sqlBuilder.append(SqlConst.BLANK).append(str);
        this.appendAlias(module, parent, context, sqlBuilder);
        return sqlBuilder;
    }

    public final boolean contain(Cmd cmd) {
        IDataset dataset;
        boolean contain = false;
        if (Objects.nonNull(this.params)) {
            contain = CmdUtils.contain((Cmd)cmd, (Object[])this.params);
        }
        if (!contain && cmd instanceof IDataset && (dataset = (IDataset)cmd).getAlias() != null && !dataset.getAlias().isEmpty()) {
            return this.template.contains(dataset.getAlias() + ".");
        }
        return contain;
    }
}

