/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.cmd.CmdConvert;
import db.sql.api.cmd.LikeMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.IParamWrap;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.basic.CmdTemplate;
import db.sql.api.impl.cmd.basic.Column;
import db.sql.api.impl.cmd.basic.Condition;
import db.sql.api.impl.cmd.basic.ConditionTemplate;
import db.sql.api.impl.cmd.basic.Count1;
import db.sql.api.impl.cmd.basic.CountAll;
import db.sql.api.impl.cmd.basic.DatePattern;
import db.sql.api.impl.cmd.basic.FALSE;
import db.sql.api.impl.cmd.basic.FunTemplate;
import db.sql.api.impl.cmd.basic.NULL;
import db.sql.api.impl.cmd.basic.TRUE;
import db.sql.api.impl.cmd.condition.Between;
import db.sql.api.impl.cmd.condition.Empty;
import db.sql.api.impl.cmd.condition.Eq;
import db.sql.api.impl.cmd.condition.Exists;
import db.sql.api.impl.cmd.condition.Gt;
import db.sql.api.impl.cmd.condition.Gte;
import db.sql.api.impl.cmd.condition.ILike;
import db.sql.api.impl.cmd.condition.In;
import db.sql.api.impl.cmd.condition.IsNotNull;
import db.sql.api.impl.cmd.condition.IsNull;
import db.sql.api.impl.cmd.condition.Like;
import db.sql.api.impl.cmd.condition.Lt;
import db.sql.api.impl.cmd.condition.Lte;
import db.sql.api.impl.cmd.condition.Ne;
import db.sql.api.impl.cmd.condition.NotBetween;
import db.sql.api.impl.cmd.condition.NotEmpty;
import db.sql.api.impl.cmd.condition.NotExists;
import db.sql.api.impl.cmd.condition.NotILike;
import db.sql.api.impl.cmd.condition.NotIn;
import db.sql.api.impl.cmd.condition.NotLike;
import db.sql.api.impl.cmd.dbFun.Abs;
import db.sql.api.impl.cmd.dbFun.Acos;
import db.sql.api.impl.cmd.dbFun.Asin;
import db.sql.api.impl.cmd.dbFun.Atan;
import db.sql.api.impl.cmd.dbFun.Avg;
import db.sql.api.impl.cmd.dbFun.Case;
import db.sql.api.impl.cmd.dbFun.Ceil;
import db.sql.api.impl.cmd.dbFun.CharLength;
import db.sql.api.impl.cmd.dbFun.Concat;
import db.sql.api.impl.cmd.dbFun.ConcatWs;
import db.sql.api.impl.cmd.dbFun.Cos;
import db.sql.api.impl.cmd.dbFun.Cot;
import db.sql.api.impl.cmd.dbFun.Count;
import db.sql.api.impl.cmd.dbFun.CurrentDate;
import db.sql.api.impl.cmd.dbFun.CurrentDateTime;
import db.sql.api.impl.cmd.dbFun.CurrentTime;
import db.sql.api.impl.cmd.dbFun.DateAdd;
import db.sql.api.impl.cmd.dbFun.DateDiff;
import db.sql.api.impl.cmd.dbFun.DateFormat;
import db.sql.api.impl.cmd.dbFun.Day;
import db.sql.api.impl.cmd.dbFun.Degrees;
import db.sql.api.impl.cmd.dbFun.Divide;
import db.sql.api.impl.cmd.dbFun.Exp;
import db.sql.api.impl.cmd.dbFun.Floor;
import db.sql.api.impl.cmd.dbFun.GroupConcat;
import db.sql.api.impl.cmd.dbFun.Hour;
import db.sql.api.impl.cmd.dbFun.If;
import db.sql.api.impl.cmd.dbFun.IfNull;
import db.sql.api.impl.cmd.dbFun.InetAton;
import db.sql.api.impl.cmd.dbFun.InetNtoa;
import db.sql.api.impl.cmd.dbFun.Instr;
import db.sql.api.impl.cmd.dbFun.Left;
import db.sql.api.impl.cmd.dbFun.Length;
import db.sql.api.impl.cmd.dbFun.Log;
import db.sql.api.impl.cmd.dbFun.Lower;
import db.sql.api.impl.cmd.dbFun.Lpad;
import db.sql.api.impl.cmd.dbFun.Ltrim;
import db.sql.api.impl.cmd.dbFun.Max;
import db.sql.api.impl.cmd.dbFun.Min;
import db.sql.api.impl.cmd.dbFun.Mod;
import db.sql.api.impl.cmd.dbFun.Month;
import db.sql.api.impl.cmd.dbFun.Multiply;
import db.sql.api.impl.cmd.dbFun.Pi;
import db.sql.api.impl.cmd.dbFun.Plus;
import db.sql.api.impl.cmd.dbFun.Pow;
import db.sql.api.impl.cmd.dbFun.Radians;
import db.sql.api.impl.cmd.dbFun.Rand;
import db.sql.api.impl.cmd.dbFun.Repeat;
import db.sql.api.impl.cmd.dbFun.Replace;
import db.sql.api.impl.cmd.dbFun.Reverse;
import db.sql.api.impl.cmd.dbFun.Right;
import db.sql.api.impl.cmd.dbFun.Round;
import db.sql.api.impl.cmd.dbFun.Rpad;
import db.sql.api.impl.cmd.dbFun.Rtrim;
import db.sql.api.impl.cmd.dbFun.Sign;
import db.sql.api.impl.cmd.dbFun.Sin;
import db.sql.api.impl.cmd.dbFun.Sqrt;
import db.sql.api.impl.cmd.dbFun.Strcmp;
import db.sql.api.impl.cmd.dbFun.SubStr;
import db.sql.api.impl.cmd.dbFun.Subtract;
import db.sql.api.impl.cmd.dbFun.Sum;
import db.sql.api.impl.cmd.dbFun.Tan;
import db.sql.api.impl.cmd.dbFun.TimeUnits;
import db.sql.api.impl.cmd.dbFun.Trim;
import db.sql.api.impl.cmd.dbFun.Truncate;
import db.sql.api.impl.cmd.dbFun.Upper;
import db.sql.api.impl.cmd.dbFun.Weekday;
import db.sql.api.impl.cmd.dbFun.Year;
import db.sql.api.impl.cmd.dbFun.mysql.Field;
import db.sql.api.impl.cmd.dbFun.mysql.FindInSet;
import db.sql.api.impl.cmd.dbFun.mysql.FromUnixTime;
import db.sql.api.impl.cmd.dbFun.mysql.JsonContains;
import db.sql.api.impl.cmd.dbFun.mysql.JsonContainsPath;
import db.sql.api.impl.cmd.dbFun.mysql.JsonExtract;
import db.sql.api.impl.cmd.dbFun.mysql.Md5;
import db.sql.api.impl.cmd.dbFun.mysql.MysqlFunctions;
import db.sql.api.impl.cmd.dbFun.postgres.DistinctOn;
import db.sql.api.impl.cmd.dbFun.postgres.PostgresFunctions;
import db.sql.api.impl.cmd.postgis.ST_Contains;
import db.sql.api.impl.cmd.postgis.ST_DWithin;
import db.sql.api.impl.cmd.postgis.ST_Distance;
import db.sql.api.impl.cmd.postgis.ST_Point;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.impl.tookit.SqlUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Methods {
    public static NULL NULL() {
        return NULL.NULL;
    }

    public static TRUE TRUE() {
        return TRUE.TRUE;
    }

    public static FALSE FALSE() {
        return FALSE.FALSE;
    }

    public static ST_DWithin ST_DWithin(Cmd column, Cmd point, double distance) {
        return Methods.ST_DWithin(column, point, distance, null);
    }

    @SafeVarargs
    public static CmdTemplate tpl(String template, Object ... params) {
        return CmdTemplate.create(template, params);
    }

    @SafeVarargs
    public static CmdTemplate tpl(boolean wrapping, String template, Object ... params) {
        return CmdTemplate.create(wrapping, template, params);
    }

    @SafeVarargs
    public static FunTemplate fTpl(String template, Object ... params) {
        return FunTemplate.create(template, params);
    }

    @SafeVarargs
    public static FunTemplate fTpl(boolean wrapping, String template, Object ... params) {
        return FunTemplate.create(wrapping, template, params);
    }

    @SafeVarargs
    public static ConditionTemplate cTpl(String template, Object ... params) {
        return ConditionTemplate.create(template, params);
    }

    @SafeVarargs
    public static ConditionTemplate cTpl(boolean wrapping, String template, Object ... params) {
        return ConditionTemplate.create(wrapping, template, params);
    }

    public static Cmd paramWrapAndConvertToCmd(Cmd column, Object param) {
        if (Objects.isNull(param)) {
            return null;
        }
        if (param instanceof Cmd) {
            return (Cmd)param;
        }
        if (!(column instanceof IParamWrap)) {
            return new BasicValue(param);
        }
        IParamWrap paramWrap = (IParamWrap)column;
        return new BasicValue(paramWrap.paramWrap(param));
    }

    public static Object likeParamWrap(Cmd column, Object param, LikeMode mode, boolean isNotLike) {
        if (Objects.isNull(param)) {
            return null;
        }
        if (param instanceof Cmd) {
            return param;
        }
        if (!(column instanceof IParamWrap)) {
            return param;
        }
        IParamWrap paramWrap = (IParamWrap)column;
        return paramWrap.likeParamWrap(mode, param, isNotLike);
    }

    public static Column column(String column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Column(column);
    }

    public static Column column(IDataset dataset, String column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Column(dataset, column);
    }

    public static <T> Column column(Getter<T> column) {
        return new Column(SqlUtil.getAsName(column));
    }

    public static Cmd cmd(Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        if (value instanceof Cmd) {
            return (Cmd)value;
        }
        if (value instanceof CmdConvert) {
            return ((CmdConvert)value).convert();
        }
        return new BasicValue(value);
    }

    public static BasicValue value(Serializable value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        if (value instanceof CmdConvert) {
            throw new RuntimeException("please use Methods.cmd instead");
        }
        return new BasicValue(value);
    }

    public static Plus plus(Cmd column, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Plus(column, value);
    }

    public static Plus plus(Cmd column, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Plus(column, value);
    }

    public static Subtract subtract(Cmd column, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Subtract(column, value);
    }

    public static Subtract subtract(Cmd column, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Subtract(column, value);
    }

    public static Multiply multiply(Cmd column, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Multiply(column, value);
    }

    public static Divide divide(Cmd column, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Divide(column, value);
    }

    public static Divide divide(Cmd column, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Divide(column, value);
    }

    public static Multiply multiply(Cmd column, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Multiply(column, value);
    }

    public static Count count(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Count(column);
    }

    public static Count1 count1() {
        return new Count1();
    }

    public static CountAll countAll() {
        return new CountAll();
    }

    public static Count count(Cmd column, boolean distinct) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Count(column, distinct);
    }

    public static Sum sum(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Sum(column);
    }

    public static Min min(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Min(column);
    }

    public static Max max(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Max(column);
    }

    public static Avg avg(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Avg(column);
    }

    public static Abs abs(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Abs(column);
    }

    public static Pow pow(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Pow(column, n);
    }

    public static Round round(Cmd column) {
        return Methods.round(column, 0);
    }

    public static Round round(Cmd column, int precision) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Round(column, precision);
    }

    public static Ceil ceil(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Ceil(column);
    }

    public static Floor floor(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Floor(column);
    }

    public static Rand rand() {
        return new Rand();
    }

    public static Rand rand(Number n) {
        return new Rand(n);
    }

    public static Sign sign(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Sign(column);
    }

    public static Pi pi() {
        return new Pi();
    }

    public static Truncate truncate(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return Methods.truncate(column, 0);
    }

    public static Truncate truncate(Cmd column, int precision) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Truncate(column, precision);
    }

    public static Sqrt sqrt(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Sqrt(column);
    }

    public static Mod mod(Cmd column, Number divisor) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(divisor);
        return new Mod(column, divisor);
    }

    public static Exp exp(int n) {
        return new Exp(n);
    }

    public static Log log(Cmd base, int number) {
        db.sql.api.impl.tookit.Objects.requireNonNull(base);
        return new Log(base, number);
    }

    public static Degrees degrees(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Degrees(column);
    }

    public static Radians radians(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Radians(column);
    }

    public static Sin sin(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Sin(column);
    }

    public static Asin asin(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Asin(column);
    }

    public static Cos cos(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Cos(column);
    }

    public static Acos acos(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Acos(column);
    }

    public static Tan tan(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Tan(column);
    }

    public static Atan atan(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Atan(column);
    }

    public static Cot cot(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Cot(column);
    }

    public static CharLength charLength(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new CharLength(column);
    }

    public static Length length(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Length(column);
    }

    public static Upper upper(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Upper(column);
    }

    public static Lower lower(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Lower(column);
    }

    public static Left left(Cmd column, int length) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Left(column, length);
    }

    public static Right right(Cmd column, int start) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Right(column, start);
    }

    public static SubStr subStr(Cmd column, int start) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new SubStr(column, start);
    }

    public static SubStr subStr(Cmd column, int start, int length) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new SubStr(column, start, length);
    }

    public static Lpad lpad(Cmd column, int length, String pad) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(pad);
        return new Lpad(column, length, pad);
    }

    public static Rpad rpad(Cmd column, int length, String pad) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(pad);
        return new Rpad(column, length, pad);
    }

    public static Trim trim(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Trim(column);
    }

    public static Ltrim ltrim(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Ltrim(column);
    }

    public static Rtrim rtrim(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Rtrim(column);
    }

    public static Strcmp strcmp(Cmd column, String str) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(str);
        return new Strcmp(column, str);
    }

    public static Repeat repeat(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Repeat(column, n);
    }

    public static Replace replace(Cmd column, String target, String replacement) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(target);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(replacement);
        return new Replace(column, target, replacement);
    }

    public static Reverse reverse(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Reverse(column);
    }

    public static FindInSet mysqlFindInSet(Cmd column, String match) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(match);
        return new FindInSet(column, match);
    }

    public static FindInSet mysqlFindInSet(Cmd column, Number match) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(match);
        return new FindInSet(column, match + "");
    }

    @SafeVarargs
    public static Field mysqlFiled(Cmd column, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        return new Field(column, values);
    }

    public static CurrentDate currentDate() {
        return new CurrentDate();
    }

    public static CurrentTime currentTime() {
        return new CurrentTime();
    }

    public static CurrentDateTime currentDateTime() {
        return new CurrentDateTime();
    }

    public static Year year(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Year(column);
    }

    public static Month month(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Month(column);
    }

    public static DateFormat date(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateFormat(column, DatePattern.YYYY_MM_DD);
    }

    public static DateFormat dateFormat(Cmd column, String pattern) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(pattern);
        return new DateFormat(column, pattern);
    }

    public static DateFormat dateFormat(Cmd column, DatePattern pattern) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(pattern);
        return new DateFormat(column, pattern);
    }

    public static Day day(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Day(column);
    }

    public static Weekday weekday(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Weekday(column);
    }

    public static Hour hour(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Hour(column);
    }

    public static DateDiff dateDiff(Cmd column, Cmd another) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(another);
        return new DateDiff(column, another);
    }

    public static DateAdd dateAdd(Cmd column, int n, TimeUnits timeUnit) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, timeUnit);
    }

    public static DateAdd dateAdd(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, TimeUnits.DAYS);
    }

    public static DateAdd dateSub(Cmd column, int n, TimeUnits timeUnit) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n * -1, timeUnit);
    }

    public static DateAdd dateSub(Cmd column, int n) {
        return Methods.dateSub(column, n);
    }

    public static DateAdd secondAdd(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, TimeUnits.SECONDS);
    }

    public static DateAdd secondSub(Cmd column, int n) {
        return Methods.secondAdd(column, n * -1);
    }

    public static DateAdd minuteAdd(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, TimeUnits.MINUTES);
    }

    public static DateAdd minuteSub(Cmd column, int n) {
        return Methods.minuteAdd(column, n * -1);
    }

    public static DateAdd hourAdd(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, TimeUnits.HOURS);
    }

    public static DateAdd hourSub(Cmd column, int n) {
        return Methods.hourAdd(column, n * -1);
    }

    public static DateAdd monthAdd(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, TimeUnits.MONTHS);
    }

    public static DateAdd monthSub(Cmd column, int n) {
        return Methods.monthAdd(column, n * -1);
    }

    public static DateAdd yearAdd(Cmd column, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new DateAdd(column, n, TimeUnits.YEARS);
    }

    public static DateAdd yearSub(Cmd column, int n) {
        return Methods.yearAdd(column, n * -1);
    }

    public static Md5 mysqlMd5(String str) {
        db.sql.api.impl.tookit.Objects.requireNonEmpty(str);
        return new Md5(str);
    }

    public static Md5 mysqlMd5(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Md5(column);
    }

    public static InetAton inetAton(String ip) {
        db.sql.api.impl.tookit.Objects.requireNonEmpty(ip);
        return new InetAton(ip);
    }

    public static InetAton inetAton(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new InetAton(column);
    }

    public static InetNtoa inetNtoa(Number ipNumber) {
        db.sql.api.impl.tookit.Objects.requireNonNull(ipNumber);
        return new InetNtoa(ipNumber);
    }

    public static InetNtoa inetNtoa(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new InetNtoa(column);
    }

    @SafeVarargs
    public static Concat concat(Cmd column, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        return new Concat(column, values);
    }

    @SafeVarargs
    public static ConcatWs concatWs(Cmd column, String split, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(split);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        return new ConcatWs(column, split, values);
    }

    public static If if_(Condition condition, Serializable value, Serializable thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static If if_(Condition condition, Cmd value, Serializable thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static If if_(Condition condition, Serializable value, Cmd thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static If if_(Condition condition, Cmd value, Cmd thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static IfNull ifNull(Cmd column, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new IfNull(column, value);
    }

    public static IfNull ifNull(Cmd column, Serializable value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new IfNull(column, value);
    }

    public static IsNull isNull(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new IsNull(column);
    }

    public static IsNotNull isNotNull(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new IsNotNull(column);
    }

    public static Eq isEmpty(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Eq(column, (Serializable)SqlConst.EMPTY);
    }

    public static Ne isNotEmpty(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Ne(column, Methods.value((Serializable)SqlConst.EMPTY));
    }

    public static Case case_() {
        return new Case();
    }

    public static Eq eq(Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Eq(column, Methods.paramWrapAndConvertToCmd(column, value));
    }

    public static Ne ne(Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Ne(column, Methods.paramWrapAndConvertToCmd(column, value));
    }

    public static NotEmpty notEmpty(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new NotEmpty(column);
    }

    public static Empty empty(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Empty(column);
    }

    public static Gt gt(Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Gt(column, Methods.paramWrapAndConvertToCmd(column, value));
    }

    public static Gte gte(Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Gte(column, Methods.paramWrapAndConvertToCmd(column, value));
    }

    public static Lt lt(Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Lt(column, Methods.paramWrapAndConvertToCmd(column, value));
    }

    public static Lte lte(Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Lte(column, Methods.paramWrapAndConvertToCmd(column, value));
    }

    @SafeVarargs
    public static In in(Cmd column, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        Cmd[] cmds = new Cmd[values.length];
        for (int i = 0; i < values.length; ++i) {
            cmds[i] = Methods.paramWrapAndConvertToCmd(column, values[i]);
        }
        return new In(column).add(cmds);
    }

    public static In in(Cmd column, Collection<?> values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        return new In(column).add(values.stream().map(item -> Methods.paramWrapAndConvertToCmd(column, item)).collect(Collectors.toList()));
    }

    public static In in(Cmd column, IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new In(column).add((Cmd)query);
    }

    @SafeVarargs
    public static NotIn notIn(Cmd column, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        Cmd[] cmds = new Cmd[values.length];
        for (int i = 0; i < values.length; ++i) {
            cmds[i] = Methods.paramWrapAndConvertToCmd(column, values[i]);
        }
        return new NotIn(column).add(cmds);
    }

    public static NotIn notIn(Cmd column, Collection<?> values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        return new NotIn(column).add(values.stream().map(item -> Methods.paramWrapAndConvertToCmd(column, item)).collect(Collectors.toList()));
    }

    public static NotIn notIn(Cmd column, IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new NotIn(column).add((Cmd)query);
    }

    public static Exists exists(IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new Exists((Cmd)query);
    }

    public static NotExists notExists(IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new NotExists((Cmd)query);
    }

    public static Between between(Cmd column, Object value, Object value2) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(value2);
        return new Between(column, Methods.paramWrapAndConvertToCmd(column, value), Methods.paramWrapAndConvertToCmd(column, value2));
    }

    public static NotBetween notBetween(Cmd column, Object value, Object value2) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(value2);
        return new NotBetween(column, Methods.paramWrapAndConvertToCmd(column, value), Methods.paramWrapAndConvertToCmd(column, value2));
    }

    public static Like like(Cmd column, Object value) {
        return Methods.like(LikeMode.DEFAULT, column, value);
    }

    public static Like like(LikeMode mode, Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        Object wrapValue = Methods.likeParamWrap(column, value, mode, false);
        if (wrapValue instanceof Object[]) {
            Object[] values = (Object[])wrapValue;
            mode = (LikeMode)values[0];
            value = values[1];
        }
        return new Like(mode, column, Methods.cmd(value));
    }

    public static NotLike notLike(Cmd column, Object value) {
        return Methods.notLike(LikeMode.DEFAULT, column, value);
    }

    public static NotLike notLike(LikeMode mode, Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        Object wrapValue = Methods.likeParamWrap(column, value, mode, true);
        if (wrapValue instanceof Object[]) {
            Object[] values = (Object[])wrapValue;
            mode = (LikeMode)values[0];
            value = values[1];
        }
        return new NotLike(mode, column, Methods.cmd(value));
    }

    public static ILike iLike(Cmd column, Object value) {
        return Methods.iLike(LikeMode.DEFAULT, column, value);
    }

    public static ILike iLike(LikeMode mode, Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        Object wrapValue = Methods.likeParamWrap(column, value, mode, false);
        if (wrapValue instanceof Object[]) {
            Object[] values = (Object[])wrapValue;
            mode = (LikeMode)values[0];
            value = values[1];
        }
        return new ILike(mode, column, Methods.cmd(value));
    }

    public static NotILike notILike(Cmd column, Object value) {
        return Methods.notILike(LikeMode.DEFAULT, column, value);
    }

    public static NotILike notILike(LikeMode mode, Cmd column, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        Object wrapValue = Methods.likeParamWrap(column, value, mode, true);
        if (wrapValue instanceof Object[]) {
            Object[] values = (Object[])wrapValue;
            mode = (LikeMode)values[0];
            value = values[1];
        }
        return new NotILike(mode, column, Methods.cmd(value));
    }

    public static FromUnixTime mysqlFromUnixTime(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new FromUnixTime(column);
    }

    public static JsonContains mysqlJsonContains(Cmd column, Serializable containValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(containValue);
        return new JsonContains(column, containValue);
    }

    public static JsonContains mysqlJsonContains(Cmd column, Serializable containValue, String path) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(containValue);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(path);
        return new JsonContains(column, containValue, path);
    }

    @SafeVarargs
    public static JsonContainsPath mysqlJsonContainsPath(Cmd column, String ... paths) {
        return Methods.mysqlJsonContainsPath(column, true, paths);
    }

    @SafeVarargs
    public static JsonContainsPath mysqlJsonContainsPath(Cmd column, boolean allMatch, String ... paths) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(paths);
        return new JsonContainsPath(column, allMatch, paths);
    }

    @SafeVarargs
    public static JsonExtract mysqlJsonExtract(Cmd column, String ... paths) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(paths);
        return new JsonExtract(column, paths);
    }

    public static Instr instr(Cmd column, String str) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(str);
        return new Instr(column, str);
    }

    public static Case sort(Cmd column, Serializable ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        Case cs = Methods.case_();
        for (int i = 0; i < values.length; ++i) {
            cs.when((Condition)Methods.eq(column, values[i]), Integer.valueOf(i + 1));
        }
        cs.else_(column);
        return cs;
    }

    public static GroupConcat groupConcat(Cmd column, String split) {
        return new GroupConcat(column, split);
    }

    public static GroupConcat groupConcat(Cmd column) {
        return Methods.groupConcat(column, ",");
    }

    public static ST_DWithin ST_DWithin(Cmd column, Cmd point, double distance, Boolean useSpheroid) {
        return new ST_DWithin(column, point, distance, useSpheroid);
    }

    public static ST_DWithin ST_DWithin(Cmd column, ST_Point point, double distance) {
        return Methods.ST_DWithin(column, point, distance, null);
    }

    public static ST_DWithin ST_DWithin(Cmd column, ST_Point point, double distance, Boolean useSpheroid) {
        return Methods.ST_DWithin(column, (Cmd)point, distance, useSpheroid);
    }

    public static ST_Distance ST_Distance(Cmd column, Cmd point) {
        return Methods.ST_Distance(column, point, null);
    }

    public static ST_Distance ST_Distance(Cmd column, Cmd point, Boolean useSpheroid) {
        return new ST_Distance(column, point, useSpheroid);
    }

    public static ST_Distance ST_Distance(Cmd column, ST_Point point) {
        return Methods.ST_Distance(column, point, null);
    }

    public static ST_Distance ST_Distance(Cmd column, ST_Point point, Boolean useSpheroid) {
        return Methods.ST_Distance(column, (Cmd)point, useSpheroid);
    }

    public static ST_Contains ST_Contains(Cmd column, Cmd geo) {
        return new ST_Contains(column, geo);
    }

    public static ST_Contains ST_Contains(Cmd column, ST_Point point) {
        return Methods.ST_Contains(column, (Cmd)point);
    }

    public static MysqlFunctions mysql() {
        return new MysqlFunctions(null);
    }

    public static MysqlFunctions mysql(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new MysqlFunctions(column);
    }

    public static PostgresFunctions postgres() {
        return new PostgresFunctions(null);
    }

    public static PostgresFunctions postgres(Cmd column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new PostgresFunctions(column);
    }

    @SafeVarargs
    public static DistinctOn postgresDistinctOn(Cmd ... onKeys) {
        db.sql.api.impl.tookit.Objects.requireNonNull(onKeys);
        return new DistinctOn(onKeys);
    }
}

