/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.cmd.LikeMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.cmd.executor.method.condition.IConditionMethods;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.executor.AbstractSubQuery;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.exception.ConditionArrayValueEmptyException;
import db.sql.api.impl.exception.ConditionValueNullException;
import db.sql.api.tookit.LambdaUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;

public class ConditionFactory
implements IConditionMethods<ICondition, Cmd, Object> {
    protected final CmdFactory cmdFactory;
    private boolean isIgnoreEmpty = false;
    private boolean isIgnoreNull = false;
    private boolean isStringTrim = false;

    public ConditionFactory(CmdFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    public ConditionChain newConditionChain(ConditionChain parent) {
        return new ConditionChain(this, parent);
    }

    public CmdFactory getCmdFactory() {
        return this.cmdFactory;
    }

    public boolean isIgnoreEmpty() {
        return this.isIgnoreEmpty;
    }

    public void setIgnoreEmpty(boolean isIgnoreEmpty) {
        this.isIgnoreEmpty = isIgnoreEmpty;
    }

    public boolean isIgnoreNull() {
        return this.isIgnoreNull;
    }

    public void setIgnoreNull(boolean isIgnoreNull) {
        this.isIgnoreNull = isIgnoreNull;
    }

    public boolean isStringTrim() {
        return this.isStringTrim;
    }

    public void setStringTrim(boolean isStringTrim) {
        this.isStringTrim = isStringTrim;
    }

    protected boolean isKeyValid(Cmd filed) {
        return filed != null;
    }

    private Object getSingleValue(Object value) {
        if (Objects.isNull(value)) {
            if (!this.isIgnoreNull()) {
                throw new ConditionValueNullException("\u6761\u4ef6\u53c2\u6570\u91cc\u5305\u542bnull\u503c");
            }
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            String string = str = this.isStringTrim() ? str.trim() : str;
            if (this.isIgnoreEmpty() && "".equals(str)) {
                return null;
            }
            return str;
        }
        return value;
    }

    protected Object checkAndGetValidValue(Object value) {
        if (Objects.isNull(value)) {
            if (!this.isIgnoreNull()) {
                throw new ConditionValueNullException("\u6761\u4ef6\u53c2\u6570\u91cc\u5305\u542bnull\u503c");
            }
            return null;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            ArrayList<Object> objectList = new ArrayList<Object>(values.length);
            for (Object v : values) {
                Object nv = this.getSingleValue(v);
                if (Objects.isNull(nv)) continue;
                objectList.add(nv);
            }
            if (!this.isIgnoreNull() && objectList.isEmpty()) {
                throw new ConditionArrayValueEmptyException("array can't be empty");
            }
            int length = objectList.size();
            if (length == values.length) {
                for (int i = 0; i < length; ++i) {
                    values[i] = objectList.get(i);
                }
                objectList.clear();
                return values;
            }
            Object[] newObject = (Object[])Array.newInstance(value.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                newObject[i] = objectList.get(i);
            }
            return newObject;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            AbstractCollection objectList = value instanceof List ? new ArrayList() : (value instanceof Set ? new HashSet(collection.size()) : (value instanceof Queue ? new ArrayDeque(collection.size()) : new ArrayList(collection.size())));
            for (Object v : collection) {
                Object nv = this.getSingleValue(v);
                if (Objects.isNull(nv)) continue;
                objectList.add(nv);
            }
            if (!this.isIgnoreNull() && objectList.isEmpty()) {
                throw new ConditionArrayValueEmptyException("collection can't be empty");
            }
            return collection;
        }
        return this.getSingleValue(value);
    }

    private Object paramWrap(Object value) {
        if (this.isStringTrim() && value instanceof String) {
            String str = (String)value;
            value = str.trim();
        }
        return value;
    }

    private <T> Cmd createTableField(Getter<T> column, int storey) {
        return this.cmdFactory.field((Getter)column, storey);
    }

    public ICondition $conditionWhenFalseRV() {
        return null;
    }

    public ICondition empty(Cmd column) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        return Methods.empty(column);
    }

    public <T> ICondition empty(boolean when, Getter<T> column, int storey) {
        if (!when) {
            return null;
        }
        return Methods.empty(this.createTableField(column, storey));
    }

    public ICondition notEmpty(Cmd column) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        return Methods.notEmpty(column);
    }

    public <T> ICondition notEmpty(boolean when, Getter<T> column, int storey) {
        if (!when) {
            return null;
        }
        return Methods.notEmpty(this.createTableField(column, storey));
    }

    public ICondition eq(Cmd column, Object value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.eq(column, this.paramWrap(value));
    }

    public ICondition ne(Cmd column, Object value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.ne(column, this.paramWrap(value));
    }

    public ICondition gt(Cmd column, Object value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.gt(column, this.paramWrap(value));
    }

    public ICondition gte(Cmd column, Object value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.gte(column, this.paramWrap(value));
    }

    public ICondition lt(Cmd column, Object value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.lt(column, this.paramWrap(value));
    }

    public ICondition lte(Cmd column, Object value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.lte(column, this.paramWrap(value));
    }

    public ICondition like(LikeMode mode, Cmd column, String value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.like(mode, column, value);
    }

    public <T> ICondition like(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.like(mode, this.createTableField(column, storey), value);
    }

    public ICondition notLike(LikeMode mode, Cmd column, String value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.notLike(mode, column, value);
    }

    public <T> ICondition notLike(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.notLike(mode, this.createTableField(column, storey), value);
    }

    public ICondition iLike(LikeMode mode, Cmd column, String value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.iLike(mode, column, value);
    }

    public <T> ICondition iLike(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.iLike(mode, this.createTableField(column, storey), value);
    }

    public ICondition notILike(LikeMode mode, Cmd column, String value) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.notILike(mode, column, value);
    }

    public <T> ICondition notILike(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = (String)this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.notILike(mode, this.createTableField(column, storey), value);
    }

    public ICondition between(Cmd column, Object value, Object value2) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        value = this.checkAndGetValidValue(value);
        value2 = this.checkAndGetValidValue(value2);
        if (Objects.isNull(value) || Objects.isNull(value2)) {
            if (Objects.isNull(value) && Objects.isNull(value2)) {
                return null;
            }
            throw new ConditionValueNullException("\u6761\u4ef6\u53c2\u6570\u91cc\u5305\u542bnull\u503c");
        }
        return Methods.between(column, value, value2);
    }

    public <T> ICondition between(boolean when, Getter<T> column, int storey, Object value, Object value2) {
        if (!when) {
            return null;
        }
        value = this.checkAndGetValidValue(value);
        value2 = this.checkAndGetValidValue(value2);
        if (Objects.isNull(value) || Objects.isNull(value2)) {
            if (Objects.isNull(value) && Objects.isNull(value2)) {
                return null;
            }
            throw new ConditionValueNullException("\u6761\u4ef6\u53c2\u6570\u91cc\u5305\u542bnull\u503c");
        }
        return Methods.between(this.createTableField(column, storey), value, value2);
    }

    public ICondition notBetween(Cmd column, Object value, Object value2) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        value = this.checkAndGetValidValue(value);
        value2 = this.checkAndGetValidValue(value2);
        if (Objects.isNull(value) || Objects.isNull(value2)) {
            if (Objects.isNull(value) && Objects.isNull(value2)) {
                return null;
            }
            throw new ConditionValueNullException("\u6761\u4ef6\u53c2\u6570\u91cc\u5305\u542bnull\u503c");
        }
        return Methods.notBetween(column, value, value2);
    }

    public <T> ICondition notBetween(boolean when, Getter<T> column, int storey, Object value, Object value2) {
        if (!when) {
            return null;
        }
        value = this.checkAndGetValidValue(value);
        value2 = this.checkAndGetValidValue(value2);
        if (Objects.isNull(value) || Objects.isNull(value2)) {
            if (Objects.isNull(value) && Objects.isNull(value2)) {
                return null;
            }
            throw new ConditionValueNullException("\u6761\u4ef6\u53c2\u6570\u91cc\u5305\u542bnull\u503c");
        }
        return Methods.notBetween(this.createTableField(column, storey), value, value2);
    }

    public ICondition isNull(Cmd column) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        return Methods.isNull(column);
    }

    public ICondition isNotNull(Cmd column) {
        if (!this.isKeyValid(column)) {
            return null;
        }
        return Methods.isNotNull(column);
    }

    public <T> ICondition eq(boolean when, Getter<T> column, int storey, Object value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.eq(this.createTableField(column, storey), this.paramWrap(value));
    }

    public <T, T2> ICondition eq(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        if (!when) {
            return null;
        }
        Object v = this.checkAndGetValidValue(value);
        if (Objects.isNull(v)) {
            return null;
        }
        return Methods.eq(this.createTableField(column, columnStorey), this.createTableField(value, valueStorey));
    }

    public <T> ICondition gt(boolean when, Getter<T> column, int storey, Object value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.gt(this.createTableField(column, storey), this.paramWrap(value));
    }

    public <T, T2> ICondition gt(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        if (!when) {
            return null;
        }
        Object v = this.checkAndGetValidValue(value);
        if (Objects.isNull(v)) {
            return null;
        }
        return Methods.gt(this.createTableField(column, columnStorey), this.createTableField(value, valueStorey));
    }

    public <T> ICondition gte(boolean when, Getter<T> column, int storey, Object value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.gte(this.createTableField(column, storey), this.paramWrap(value));
    }

    public <T, T2> ICondition gte(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        if (!when) {
            return null;
        }
        Object v = this.checkAndGetValidValue(value);
        if (Objects.isNull(v)) {
            return null;
        }
        return Methods.gte(this.createTableField(column, columnStorey), this.createTableField(value, valueStorey));
    }

    public <T> ICondition lt(boolean when, Getter<T> column, int storey, Object value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.lt(this.createTableField(column, storey), this.paramWrap(value));
    }

    public <T, T2> ICondition lt(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        if (!when) {
            return null;
        }
        Object v = this.checkAndGetValidValue(value);
        if (Objects.isNull(v)) {
            return null;
        }
        return Methods.lt(this.createTableField(column, columnStorey), this.createTableField(value, valueStorey));
    }

    public <T> ICondition lte(boolean when, Getter<T> column, int storey, Object value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.lte(this.createTableField(column, storey), this.paramWrap(value));
    }

    public <T, T2> ICondition lte(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        if (!when) {
            return null;
        }
        Object v = this.checkAndGetValidValue(value);
        if (Objects.isNull(v)) {
            return null;
        }
        return Methods.lte(this.createTableField(column, columnStorey), this.createTableField(value, valueStorey));
    }

    public <T> ICondition ne(boolean when, Getter<T> column, int storey, Object value) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(value = this.checkAndGetValidValue(value))) {
            return null;
        }
        return Methods.ne(this.createTableField(column, storey), this.paramWrap(value));
    }

    public <T, T2> ICondition ne(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        if (!when) {
            return null;
        }
        Object v = this.checkAndGetValidValue(value);
        if (Objects.isNull(v)) {
            return null;
        }
        return Methods.ne(this.createTableField(column, columnStorey), this.createTableField(value, valueStorey));
    }

    public <T> ICondition isNull(boolean when, Getter<T> column, int storey) {
        if (!when) {
            return null;
        }
        return Methods.isNull(this.createTableField(column, storey));
    }

    public <T> ICondition isNotNull(boolean when, Getter<T> column, int storey) {
        if (!when) {
            return null;
        }
        return Methods.isNotNull(this.createTableField(column, storey));
    }

    public ICondition in(Cmd column, IQuery query) {
        Objects.requireNonNull(query);
        return Methods.in(column, query);
    }

    @SafeVarargs
    public final ICondition in(Cmd column, Serializable ... values) {
        if (Objects.isNull(values = (Serializable[])this.checkAndGetValidValue(values)) || values.length == 0) {
            return null;
        }
        return Methods.in(column, values);
    }

    public ICondition in(Cmd column, Collection<? extends Serializable> values) {
        if (Objects.isNull(values = (Collection)this.checkAndGetValidValue(values)) || values.isEmpty()) {
            return null;
        }
        return Methods.in(column, values);
    }

    public <T> ICondition in(boolean when, Getter<T> column, int storey, IQuery query) {
        if (!when) {
            return null;
        }
        Objects.requireNonNull(query);
        return Methods.in(this.createTableField(column, storey), query);
    }

    @SafeVarargs
    public final <T> ICondition in(boolean when, Getter<T> column, int storey, Serializable ... values) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(values = (Serializable[])this.checkAndGetValidValue(values)) || values.length == 0) {
            return null;
        }
        return Methods.in(this.createTableField(column, storey), values);
    }

    public <T> ICondition in(boolean when, Getter<T> column, int storey, Collection<? extends Serializable> values) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(values = (Collection)this.checkAndGetValidValue(values)) || values.isEmpty()) {
            return null;
        }
        return Methods.in(this.createTableField(column, storey), values);
    }

    public ICondition exists(boolean when, IQuery query) {
        if (!when) {
            return null;
        }
        Objects.requireNonNull(query);
        return Methods.exists(query);
    }

    public <T1, T2> ICondition exists(boolean when, Getter<T1> sourceGetter, int sourceStorey, Getter<T2> targetGetter) {
        if (!when) {
            return null;
        }
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(targetGetter);
        return Methods.exists((IQuery)((AbstractSubQuery)((AbstractSubQuery)this.cmdFactory.createSubQuery().select1()).from(new Class[]{lambdaFieldInfo.getType()})).eq(targetGetter, this.cmdFactory.field((Getter)sourceGetter, sourceStorey)));
    }

    public ICondition notExists(boolean when, IQuery query) {
        if (!when) {
            return null;
        }
        Objects.requireNonNull(query);
        return Methods.notExists(query);
    }

    public <T1, T2> ICondition notExists(boolean when, Getter<T1> sourceGetter, int sourceStorey, Getter<T2> targetGetter) {
        if (!when) {
            return null;
        }
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(targetGetter);
        return Methods.notExists((IQuery)((AbstractSubQuery)((AbstractSubQuery)this.cmdFactory.createSubQuery().select1()).from(new Class[]{lambdaFieldInfo.getType()})).eq(targetGetter, this.cmdFactory.field((Getter)sourceGetter, sourceStorey)));
    }

    public ICondition notIn(Cmd column, IQuery query) {
        Objects.requireNonNull(query);
        return Methods.notIn(column, query);
    }

    @SafeVarargs
    public final ICondition notIn(Cmd column, Serializable ... values) {
        if (Objects.isNull(values = (Serializable[])this.checkAndGetValidValue(values)) || values.length == 0) {
            return null;
        }
        return Methods.notIn(column, values);
    }

    public ICondition notIn(Cmd column, Collection<? extends Serializable> values) {
        if (Objects.isNull(values = (Collection)this.checkAndGetValidValue(values)) || values.isEmpty()) {
            return null;
        }
        return Methods.notIn(column, values);
    }

    public <T> ICondition notIn(boolean when, Getter<T> column, int storey, IQuery query) {
        if (!when) {
            return null;
        }
        Objects.requireNonNull(query);
        return Methods.notIn(this.createTableField(column, storey), query);
    }

    @SafeVarargs
    public final <T> ICondition notIn(boolean when, Getter<T> column, int storey, Serializable ... values) {
        if (!when) {
            return null;
        }
        Object[] newValues = (Serializable[])this.checkAndGetValidValue(values);
        if (Objects.isNull(newValues) || newValues.length == 0) {
            return null;
        }
        return Methods.notIn(this.createTableField(column, storey), newValues);
    }

    public <T> ICondition notIn(boolean when, Getter<T> column, int storey, Collection<? extends Serializable> values) {
        if (!when) {
            return null;
        }
        if (Objects.isNull(values = (Collection)this.checkAndGetValidValue(values)) || values.isEmpty()) {
            return null;
        }
        return Methods.notIn(this.createTableField(column, storey), values);
    }

    public <T1, T2> ICondition exists(boolean when, Getter<T1> sourceGetter, int sourceStorey, Getter<T2> targetGetter, Consumer<AbstractSubQuery<?, ?>> consumer) {
        if (!when) {
            return null;
        }
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(targetGetter);
        return Methods.exists((IQuery)((AbstractSubQuery)((AbstractSubQuery)((AbstractSubQuery)this.cmdFactory.createSubQuery().select1()).from(new Class[]{lambdaFieldInfo.getType()})).eq(targetGetter, this.cmdFactory.field((Getter)sourceGetter, sourceStorey))).connect(consumer != null, q -> consumer.accept((AbstractSubQuery<?, ?>)q)));
    }

    public <T1, T2> ICondition notExists(boolean when, Getter<T1> sourceGetter, int sourceStorey, Getter<T2> targetGetter, Consumer<AbstractSubQuery<?, ?>> consumer) {
        if (!when) {
            return null;
        }
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(targetGetter);
        return Methods.notExists((IQuery)((AbstractSubQuery)((AbstractSubQuery)((AbstractSubQuery)this.cmdFactory.createSubQuery().select1()).from(new Class[]{lambdaFieldInfo.getType()})).eq(targetGetter, this.cmdFactory.field((Getter)sourceGetter, sourceStorey))).connect(consumer != null, q -> consumer.accept((AbstractSubQuery<?, ?>)q)));
    }
}

