/*
 *  Copyright (c) 2024-2025, Ai东 (abc-127@live.cn) xbatis.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License").
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and limitations under the License.
 *
 */

package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import db.sql.api.tookit.SqlInjectionUtils;

import java.util.Objects;

public class Column extends AbstractDatasetField<Column> {

    public Column(String name) {
        this(null, name);
    }

    public Column(IDataset dataset, String name) {
        super(dataset, name);
        if (SqlInjectionUtils.check(name)) {
            throw new IllegalArgumentException("Column name may be not safe");
        }
    }

    @Override
    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(SqlConst.BLANK).append(getName(context.getDbType()));
        if (Objects.nonNull(this.alias)) {
            if (parent instanceof Select) {
                sqlBuilder.append(SqlConst.BLANK).append(this.alias);
            }
        }
        return sqlBuilder;
    }

    @Override
    public boolean contain(Cmd cmd) {
        boolean contain = false;

        if (Objects.nonNull(getTable())) {
            contain = CmdUtils.contain(cmd, getTable());
        }

        if (!contain && cmd instanceof IDataset) {
            //支持字符串列；需要含有“别名.xx"的情况
            IDataset dataset = (IDataset) cmd;
            if (dataset.getAlias() != null && !dataset.getAlias().isEmpty()) {
                return getName().contains(dataset.getAlias() + ".");
            }
        }

        return contain;
    }
}
