/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.paging;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.Alias;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.cmd.struct.query.IOrderBy;
import db.sql.api.cmd.struct.query.ISelect;
import db.sql.api.cmd.struct.query.Withs;
import db.sql.api.impl.cmd.condition.In;
import db.sql.api.impl.cmd.struct.Limit;
import db.sql.api.impl.cmd.struct.update.UpdateSet;
import db.sql.api.impl.paging.IPagingProcessor;
import db.sql.api.impl.paging.RowNumNameUtil;
import db.sql.api.tookit.CmdUtils;
import java.util.List;

public class SQLServerRowNumberOverPagingProcessor
implements IPagingProcessor {
    @Override
    public StringBuilder buildPagingSQL(SqlBuilderContext context, Cmd module, Cmd parent, IQuery query, StringBuilder parentSQL, List<Cmd> beforeCmds, List<Cmd> afterCmds, Limit limit) {
        List selectFields;
        if (parentSQL == null) {
            parentSQL = new StringBuilder();
        }
        String alias = null;
        if (query instanceof Alias) {
            alias = ((Alias)query).getAlias();
        }
        if (alias == null || alias.isEmpty()) {
            alias = "NT";
        }
        StringBuilder orderBy = query.getOrderBy() != null ? query.getOrderBy().sql(module, parent, context, new StringBuilder()) : new StringBuilder("ORDER BY CURRENT_TIMESTAMP");
        StringBuilder sql = new StringBuilder(200);
        sql.append("SELECT TOP ").append(limit.getLimit()).append(" ");
        boolean handlerSelect = false;
        if (parent != null && (parent instanceof In || parent instanceof UpdateSet) && (selectFields = query.getSelect().getSelectField()).size() == 1) {
            IDatasetField a;
            Cmd cmd = (Cmd)selectFields.get(0);
            if (cmd instanceof IDatasetField) {
                a = (IDatasetField)cmd;
                if (a.getAlias() != null) {
                    sql.append(a.getAlias());
                } else {
                    sql.append(a.getName(context.getDbType()));
                }
                handlerSelect = true;
            } else if (cmd instanceof Alias && (a = (Alias)cmd).getAlias() != null) {
                sql.append(a.getAlias());
                handlerSelect = true;
            }
        }
        if (!handlerSelect) {
            sql.append("*");
        }
        sql.append(" FROM (");
        String rnName = RowNumNameUtil.getRowName(context);
        for (Cmd cmd : beforeCmds) {
            if (cmd instanceof Withs) {
                cmd.sql(module, parent, context, parentSQL);
                continue;
            }
            if (cmd instanceof IOrderBy) continue;
            cmd.sql(module, parent, context, sql);
            if (!(cmd instanceof ISelect)) continue;
            sql.append(",ROW_NUMBER() OVER(").append((CharSequence)orderBy).append(") ").append(rnName);
        }
        sql.append((CharSequence)CmdUtils.join((Cmd)module, (Cmd)query, (SqlBuilderContext)context, (StringBuilder)new StringBuilder(), afterCmds));
        sql.append(") ").append(alias);
        sql.append(" WHERE ").append(rnName).append(" > ").append(limit.getOffset());
        return parentSQL.append((CharSequence)sql);
    }
}

