/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.paging;

import db.sql.api.DbType;
import db.sql.api.impl.paging.CommonPagingProcessor;
import db.sql.api.impl.paging.IPagingProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PagingProcessorFactory {
    private static final Map<DbType, IPagingProcessor> MAP = new ConcurrentHashMap<DbType, IPagingProcessor>();

    public static void setProcessor(DbType dbType, IPagingProcessor processor) {
        MAP.putIfAbsent(dbType, processor);
    }

    public static IPagingProcessor getProcessor(DbType dbType) {
        return MAP.computeIfAbsent(dbType, c -> new CommonPagingProcessor());
    }
}

