/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.paging;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.Alias;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.impl.cmd.condition.In;
import db.sql.api.impl.cmd.struct.Limit;
import db.sql.api.impl.cmd.struct.update.UpdateSet;
import db.sql.api.impl.paging.IPagingProcessor;
import db.sql.api.impl.paging.RowNumNameUtil;
import db.sql.api.tookit.CmdUtils;
import java.util.List;

public class OracleRowNumPagingProcessor
implements IPagingProcessor {
    @Override
    public StringBuilder buildPagingSQL(SqlBuilderContext context, Cmd module, Cmd parent, IQuery query, StringBuilder parentSQL, List<Cmd> beforeCmds, List<Cmd> afterCmds, Limit limit) {
        if (parentSQL == null) {
            parentSQL = new StringBuilder(200);
        }
        StringBuilder querySQL = CmdUtils.join((Cmd)module, (Cmd)query, (SqlBuilderContext)context, (StringBuilder)new StringBuilder(), beforeCmds);
        parentSQL.append((CharSequence)this.sql(context, parent, query, querySQL, limit));
        parentSQL = CmdUtils.join((Cmd)module, (Cmd)query, (SqlBuilderContext)context, (StringBuilder)parentSQL, afterCmds);
        return parentSQL;
    }

    public StringBuilder sql(SqlBuilderContext sqlBuilderContext, Cmd parent, IQuery query, StringBuilder sql, Limit limit) {
        List selectFields;
        String alias = null;
        if (query instanceof Alias) {
            alias = ((Alias)query).getAlias();
        }
        if (alias == null || alias.isEmpty()) {
            alias = "NT";
        }
        String rnName = RowNumNameUtil.getRowName(sqlBuilderContext);
        StringBuilder newSql = new StringBuilder("SELECT ");
        boolean handlerSelect = false;
        if (parent != null && (parent instanceof In || parent instanceof UpdateSet) && (selectFields = query.getSelect().getSelectField()).size() == 1) {
            Alias a;
            Cmd cmd = (Cmd)selectFields.get(0);
            if (cmd instanceof IDatasetField) {
                IDatasetField a2 = (IDatasetField)cmd;
                if (a2.getAlias() != null) {
                    newSql.append(a2.getAlias());
                } else {
                    newSql.append(a2.getName(sqlBuilderContext.getDbType()));
                }
                handlerSelect = true;
            } else if (cmd instanceof Alias && (a = (Alias)cmd).getAlias() != null) {
                newSql.append(a.getAlias());
                handlerSelect = true;
            }
        }
        if (!handlerSelect) {
            newSql.append("*");
        }
        return newSql.append("  FROM ( SELECT IT.*,ROWNUM ").append(rnName).append(" FROM (").append((CharSequence)sql).append(") IT WHERE ROWNUM <= ").append(limit.getLimit() + limit.getOffset()).append(") ").append(alias).append(" WHERE ").append(alias).append(".").append(rnName).append(" >").append(limit.getOffset());
    }
}

