/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.struct.update;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.executor.IInsert;
import db.sql.api.cmd.struct.update.IUpdateSet;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.AbstractUpdate;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.util.Objects;

public class UpdateSet
implements IUpdateSet<TableField, Cmd> {
    private final TableField field;
    private final Cmd value;

    public UpdateSet(TableField field, Cmd value) {
        this.field = field;
        this.value = value;
    }

    public TableField getField() {
        return this.field;
    }

    public Cmd getValue() {
        return this.value;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.KING_BASE || context.getDbType() == DbType.OPEN_GAUSS || module instanceof IInsert) {
            sqlBuilder.append(this.field.getName(context.getDbType()));
        } else if (context.getDbType() == DbType.SQL_SERVER) {
            AbstractUpdate abstractUpdate = (AbstractUpdate)module;
            if (Objects.nonNull(abstractUpdate.getFrom())) {
                sqlBuilder = this.field.sql(module, (Cmd)this, context, sqlBuilder);
            } else {
                sqlBuilder.append(this.field.getName(context.getDbType()));
            }
        } else {
            sqlBuilder = this.field.sql(module, (Cmd)this, context, sqlBuilder);
        }
        sqlBuilder.append(SqlConst.EQ);
        sqlBuilder = this.value.sql(module, (Cmd)this, context, sqlBuilder);
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, (Object[])new Object[]{this.field, this.value});
    }
}

