/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.struct;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.GetterField;
import db.sql.api.cmd.LikeMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.cmd.struct.conditionChain.IConditionChain;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.basic.ConditionBlock;
import db.sql.api.impl.cmd.basic.Connector;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.On;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ConditionChain
implements IConditionChain<ConditionChain, TableField, Cmd, Object>,
ICondition {
    private final ConditionFactory conditionFactory;
    private final ConditionChain parent;
    private List<ConditionBlock> conditionBlocks;
    private Connector connector = Connector.AND;

    public ConditionChain(ConditionFactory conditionFactory) {
        this(conditionFactory, null);
    }

    public ConditionChain(ConditionFactory conditionFactory, ConditionChain parent) {
        this.conditionFactory = conditionFactory;
        this.parent = parent;
    }

    public ConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    public ConditionChain setIgnoreNull(boolean bool) {
        this.conditionFactory.setIgnoreNull(bool);
        return this;
    }

    public ConditionChain setIgnoreEmpty(boolean bool) {
        this.conditionFactory.setIgnoreEmpty(bool);
        return this;
    }

    public ConditionChain setStringTrim(boolean bool) {
        this.conditionFactory.setStringTrim(bool);
        return this;
    }

    public ConditionChain and(ICondition condition) {
        this.and();
        if (Objects.nonNull(condition)) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain or(ICondition condition) {
        this.or();
        if (Objects.nonNull(condition)) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public boolean hasContent() {
        return this.conditionBlocks != null && !this.conditionBlocks.isEmpty();
    }

    public ConditionChain newInstance() {
        return this.conditionFactory.newConditionChain(this);
    }

    protected void appendCondition(Connector connector, ICondition condition) {
        if (condition == null) {
            return;
        }
        if (this.conditionBlocks == null) {
            this.conditionBlocks = new ArrayList<ConditionBlock>(4);
        }
        this.conditionBlocks.add(new ConditionBlock(connector, condition));
    }

    public List<ConditionBlock> getConditionBlocks() {
        return this.conditionBlocks;
    }

    public ConditionChain and() {
        this.connector = Connector.AND;
        return this;
    }

    public ConditionChain or() {
        this.connector = Connector.OR;
        return this;
    }

    public <T> ConditionChain and(boolean when, Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.and();
        if (!when) {
            return this;
        }
        return this.and(f.apply((TableField)this.conditionFactory.getCmdFactory().field((Getter)column, storey)));
    }

    public <T> ConditionChain or(boolean when, Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.or();
        if (!when) {
            return this;
        }
        return this.or(f.apply((TableField)this.conditionFactory.getCmdFactory().field((Getter)column, storey)));
    }

    public ConditionChain and(boolean when, GetterField[] getterFields, Function<TableField[], ICondition> f) {
        if (!when) {
            return this;
        }
        return this.and(f.apply(this.conditionFactory.getCmdFactory().fields(getterFields)));
    }

    public ConditionChain or(boolean when, GetterField[] getterFields, Function<TableField[], ICondition> f) {
        if (!when) {
            return this;
        }
        return this.or(f.apply(this.conditionFactory.getCmdFactory().fields(getterFields)));
    }

    public <T> ConditionChain empty(boolean when, Getter<T> column, int storey) {
        ICondition condition = this.conditionFactory.empty(when, column, storey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain empty(Cmd column) {
        ICondition condition = this.conditionFactory.empty(column);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notEmpty(boolean when, Getter<T> column, int storey) {
        ICondition condition = this.conditionFactory.notEmpty(when, column, storey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notEmpty(Cmd column) {
        ICondition condition = this.conditionFactory.notEmpty(column);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain eq(Cmd column, Object value) {
        ICondition condition = this.conditionFactory.eq(column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain ne(Cmd column, Object value) {
        ICondition condition = this.conditionFactory.ne(column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain gt(Cmd column, Object value) {
        ICondition condition = this.conditionFactory.gt(column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain gte(Cmd column, Object value) {
        ICondition condition = this.conditionFactory.gte(column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain lt(Cmd column, Object value) {
        ICondition condition = this.conditionFactory.lt(column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain lte(Cmd column, Object value) {
        ICondition condition = this.conditionFactory.lte(column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain between(Cmd column, Object value, Object value2) {
        ICondition condition = this.conditionFactory.between(column, value, value2);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notBetween(Cmd column, Object value, Object value2) {
        ICondition condition = this.conditionFactory.notBetween(column, value, value2);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain isNull(Cmd column) {
        ICondition condition = this.conditionFactory.isNull(column);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain isNotNull(Cmd column) {
        ICondition condition = this.conditionFactory.isNotNull(column);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain like(LikeMode mode, Cmd column, String value) {
        ICondition condition = this.conditionFactory.like(mode, column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notLike(LikeMode mode, Cmd column, String value) {
        ICondition condition = this.conditionFactory.notLike(mode, column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain iLike(LikeMode mode, Cmd column, String value) {
        ICondition condition = this.conditionFactory.iLike(mode, column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notILike(LikeMode mode, Cmd column, String value) {
        ICondition condition = this.conditionFactory.notILike(mode, column, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain between(boolean when, Getter<T> column, int storey, Object value, Object value2) {
        ICondition condition = this.conditionFactory.between(when, column, storey, value, value2);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain eq(boolean when, Getter<T> column, int storey, Object value) {
        ICondition condition = this.conditionFactory.eq(when, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T, T2> ConditionChain eq(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        ICondition condition = this.conditionFactory.eq(when, column, columnStorey, value, valueStorey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain gt(boolean when, Getter<T> column, int storey, Object value) {
        ICondition condition = this.conditionFactory.gt(when, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T, T2> ConditionChain gt(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        ICondition condition = this.conditionFactory.gt(when, column, columnStorey, value, valueStorey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain gte(boolean when, Getter<T> column, int storey, Object value) {
        ICondition condition = this.conditionFactory.gte(when, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T, T2> ConditionChain gte(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        ICondition condition = this.conditionFactory.gte(when, column, columnStorey, value, valueStorey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain like(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        ICondition condition = this.conditionFactory.like(when, mode, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain iLike(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        ICondition condition = this.conditionFactory.iLike(when, mode, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notLike(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        ICondition condition = this.conditionFactory.notLike(when, mode, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notILike(boolean when, LikeMode mode, Getter<T> column, int storey, String value) {
        ICondition condition = this.conditionFactory.notILike(when, mode, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain lt(boolean when, Getter<T> column, int storey, Object value) {
        ICondition condition = this.conditionFactory.lt(when, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T, T2> ConditionChain lt(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        ICondition condition = this.conditionFactory.lt(when, column, columnStorey, value, valueStorey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain lte(boolean when, Getter<T> column, int storey, Object value) {
        ICondition condition = this.conditionFactory.lte(when, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T, T2> ConditionChain lte(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        ICondition condition = this.conditionFactory.lte(when, column, columnStorey, value, valueStorey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain ne(boolean when, Getter<T> column, int storey, Object value) {
        ICondition condition = this.conditionFactory.ne(when, column, storey, value);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T, T2> ConditionChain ne(boolean when, Getter<T> column, int columnStorey, Getter<T2> value, int valueStorey) {
        ICondition condition = this.conditionFactory.ne(when, column, columnStorey, value, valueStorey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notBetween(boolean when, Getter<T> column, int storey, Object value, Object value2) {
        ICondition condition = this.conditionFactory.notBetween(when, column, storey, value, value2);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain isNotNull(boolean when, Getter<T> column, int storey) {
        ICondition condition = this.conditionFactory.isNotNull(when, column, storey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain isNull(boolean when, Getter<T> column, int storey) {
        ICondition condition = this.conditionFactory.isNull(when, column, storey);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain in(Cmd cmd, IQuery query) {
        ICondition condition = this.conditionFactory.in(cmd, query);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain in(Cmd cmd, Serializable ... values) {
        ICondition condition = this.conditionFactory.in(cmd, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain in(Cmd cmd, Collection<? extends Serializable> values) {
        ICondition condition = this.conditionFactory.in(cmd, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain in(boolean when, Getter<T> column, int storey, IQuery query) {
        ICondition condition = this.conditionFactory.in(when, column, storey, query);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain in(boolean when, Getter<T> column, int storey, Serializable[] values) {
        ICondition condition = this.conditionFactory.in(when, column, storey, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain in(boolean when, Getter<T> column, int storey, Collection<? extends Serializable> values) {
        ICondition condition = this.conditionFactory.in(when, column, storey, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain exists(boolean when, IQuery query) {
        ICondition condition = this.conditionFactory.exists(when, query);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notExists(boolean when, IQuery query) {
        ICondition condition = this.conditionFactory.notExists(when, query);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notIn(Cmd cmd, IQuery query) {
        ICondition condition = this.conditionFactory.notIn(cmd, query);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notIn(Cmd cmd, Serializable ... values) {
        ICondition condition = this.conditionFactory.notIn(cmd, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public ConditionChain notIn(Cmd cmd, Collection<? extends Serializable> values) {
        ICondition condition = this.conditionFactory.notIn(cmd, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notIn(boolean when, Getter<T> column, int storey, IQuery query) {
        ICondition condition = this.conditionFactory.notIn(when, column, storey, query);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notIn(boolean when, Getter<T> column, int storey, Serializable[] values) {
        ICondition condition = this.conditionFactory.notIn(when, column, storey, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public <T> ConditionChain notIn(boolean when, Getter<T> column, int storey, Collection<? extends Serializable> values) {
        ICondition condition = this.conditionFactory.notIn(when, column, storey, values);
        if (condition != null) {
            this.appendCondition(this.connector, condition);
        }
        return this;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (this.conditionBlocks == null || this.conditionBlocks.isEmpty()) {
            return sqlBuilder;
        }
        if (!(parent instanceof Where) && !(parent instanceof On) || this.parent != null) {
            sqlBuilder.append(SqlConst.BLANK).append(SqlConst.BRACKET_LEFT);
        }
        boolean isFirst = true;
        for (ConditionBlock conditionBlock : this.conditionBlocks) {
            ConditionChain conditionChain;
            if (conditionBlock.getCondition() instanceof ConditionChain && !(conditionChain = (ConditionChain)conditionBlock.getCondition()).hasContent()) continue;
            if (!isFirst) {
                sqlBuilder.append(SqlConst.BLANK).append((Object)conditionBlock.getConnector()).append(SqlConst.BLANK);
            }
            conditionBlock.getCondition().sql(module, (Cmd)this, context, sqlBuilder);
            isFirst = false;
        }
        if (!(parent instanceof Where) && !(parent instanceof On) || this.parent != null) {
            sqlBuilder.append(SqlConst.BRACKET_RIGHT).append(SqlConst.BLANK);
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.conditionBlocks);
    }
}

