/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.postgis;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.tookit.SqlConst;
import java.math.BigDecimal;

public class ST_Point
implements Cmd {
    private BasicValue x;
    private BasicValue y;
    private int srid;

    public ST_Point(double x, double y, int srid) {
        this.x = new BasicValue(x);
        this.y = new BasicValue(y);
        this.srid = srid;
    }

    public ST_Point(double x, double y) {
        this(x, y, 4326);
    }

    public ST_Point(BigDecimal x, BigDecimal y, int srid) {
        this.x = new BasicValue(x);
        this.y = new BasicValue(y);
        this.srid = srid;
    }

    public ST_Point(BigDecimal x, BigDecimal y) {
        this(x, y, 4326);
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (this.srid != 0) {
            if (context.getDbType() == DbType.MYSQL || context.getDbType() == DbType.MARIA_DB) {
                sqlBuilder.append("ST_SRID(");
            } else {
                sqlBuilder = sqlBuilder.append("ST_SetSRID(");
            }
        }
        sqlBuilder = context.getDbType() == DbType.MYSQL || context.getDbType() == DbType.MARIA_DB ? sqlBuilder.append("Point(") : sqlBuilder.append("ST_MakePoint(");
        sqlBuilder = this.x.sql(module, parent, context, sqlBuilder);
        sqlBuilder = sqlBuilder.append(SqlConst.DELIMITER);
        sqlBuilder = this.y.sql(module, parent, context, sqlBuilder);
        sqlBuilder = sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        sqlBuilder = sqlBuilder.append(SqlConst.DELIMITER);
        if (this.srid != 0) {
            sqlBuilder = sqlBuilder.append(this.srid);
            sqlBuilder = sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return false;
    }
}

