/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.DbType;
import db.sql.api.impl.cmd.executor.DbTypeCallable;
import db.sql.api.impl.cmd.executor.SelectorCall;
import db.sql.api.impl.tookit.Objects;
import java.util.HashMap;
import java.util.Map;

public class DbSelectorCall<R>
implements SelectorCall<R> {
    private final Map<DbType, DbTypeCallable> consumers = new HashMap<DbType, DbTypeCallable>();
    private DbTypeCallable<R> otherwise;

    @Override
    public DbSelectorCall<R> when(DbType dbType, DbTypeCallable<R> runnable) {
        this.consumers.put(dbType, runnable);
        return this;
    }

    @Override
    public DbSelectorCall<R> when(DbType[] dbTypes, DbTypeCallable<R> runnable) {
        for (DbType dbType : dbTypes) {
            this.consumers.put(dbType, runnable);
        }
        return this;
    }

    @Override
    public DbSelectorCall<R> otherwise(DbTypeCallable<R> runnable) {
        if (Objects.nonNull(this.otherwise)) {
            throw new RuntimeException("The method of 'otherwise' has already called");
        }
        this.otherwise = runnable;
        return this;
    }

    @Override
    public DbSelectorCall<R> otherwise() {
        return this.otherwise((DbType dbType) -> null);
    }

    private R execute(DbType dbType, DbTypeCallable<R> callable) {
        try {
            return callable.call(dbType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public R dbExecute(DbType dbType) {
        DbTypeCallable runnable = this.consumers.get(dbType);
        if (Objects.nonNull(runnable)) {
            return this.execute(dbType, runnable);
        }
        if (Objects.nonNull(this.otherwise)) {
            return this.execute(dbType, this.otherwise);
        }
        throw new RuntimeException("Not adapted to DbType " + dbType);
    }
}

