/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.DbType;
import db.sql.api.cmd.executor.Runnable;
import db.sql.api.impl.cmd.executor.Selector;
import db.sql.api.impl.tookit.Objects;
import java.util.HashMap;
import java.util.Map;

public class DbSelector
implements Selector {
    private final Map<DbType, Runnable> consumers = new HashMap<DbType, Runnable>();
    private Runnable otherwise;

    @Override
    public DbSelector when(DbType dbType, Runnable runnable) {
        this.consumers.put(dbType, runnable);
        return this;
    }

    @Override
    public DbSelector when(DbType[] dbTypes, Runnable runnable) {
        for (DbType dbType : dbTypes) {
            this.consumers.put(dbType, runnable);
        }
        return this;
    }

    @Override
    public DbSelector otherwise(Runnable runnable) {
        if (Objects.nonNull(this.otherwise)) {
            throw new RuntimeException("The method of 'otherwise' has already called");
        }
        this.otherwise = runnable;
        return this;
    }

    @Override
    public DbSelector otherwise() {
        return this.otherwise(() -> {});
    }

    @Override
    public void dbExecute(DbType dbType) {
        Runnable runnable = this.consumers.get(dbType);
        if (Objects.nonNull(runnable)) {
            runnable.run();
            return;
        }
        if (Objects.nonNull(this.otherwise)) {
            this.otherwise.run();
            return;
        }
        throw new RuntimeException("Not adapted to DbType " + dbType);
    }
}

