/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.ColumnField;
import db.sql.api.cmd.GetterField;
import db.sql.api.cmd.IColumnField;
import db.sql.api.cmd.JoinMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.basic.ICount1;
import db.sql.api.cmd.basic.ICountAll;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.cmd.basic.IOrderByDirection;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.cmd.basic.UnionsCmdLists;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.cmd.executor.IWithQuery;
import db.sql.api.cmd.struct.IJoin;
import db.sql.api.cmd.struct.IOn;
import db.sql.api.cmd.struct.Joins;
import db.sql.api.cmd.struct.query.IUnion;
import db.sql.api.cmd.struct.query.IWith;
import db.sql.api.cmd.struct.query.Unions;
import db.sql.api.cmd.struct.query.Withs;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.Count1;
import db.sql.api.impl.cmd.basic.CountAll;
import db.sql.api.impl.cmd.basic.OrderByDirection;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.BaseExecutor;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.cmd.struct.ForUpdate;
import db.sql.api.impl.cmd.struct.From;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.cmd.struct.Limit;
import db.sql.api.impl.cmd.struct.On;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.cmd.struct.query.GroupBy;
import db.sql.api.impl.cmd.struct.query.Having;
import db.sql.api.impl.cmd.struct.query.OrderBy;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.cmd.struct.query.Union;
import db.sql.api.impl.cmd.struct.query.With;
import db.sql.api.impl.tookit.QuerySQLUtil;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import db.sql.api.tookit.LambdaUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractQuery<SELF extends AbstractQuery<SELF, CMD_FACTORY>, CMD_FACTORY extends CmdFactory>
extends BaseExecutor<SELF, CMD_FACTORY>
implements IQuery<SELF, Table, TableField, Cmd, Object, CMD_FACTORY, ConditionChain, With, Select, From, Join, On, Joins<Join>, Where, GroupBy, Having, OrderBy, Limit, ForUpdate, Union>,
Cmd {
    protected final ConditionFactory conditionFactory;
    protected final CMD_FACTORY $;
    protected Select select;
    protected Withs withs;
    protected From from;
    protected Where where;
    protected Joins joins;
    protected GroupBy groupBy;
    protected Having having;
    protected OrderBy orderBy;
    protected Limit limit;
    protected ForUpdate forUpdate;
    protected Unions unions;
    protected Map<String, Consumer<Where>> fetchFilters;
    protected Map<String, Boolean> fetchEnables;

    public AbstractQuery(CMD_FACTORY $) {
        this.$ = $;
        this.conditionFactory = ((CmdFactory)$).createConditionFactory();
    }

    public AbstractQuery(Where where) {
        this.$ = where.getConditionFactory().getCmdFactory();
        this.conditionFactory = where.getConditionFactory();
        this.where = where;
        this.append((Cmd)where);
    }

    @Override
    public CMD_FACTORY $() {
        return this.$;
    }

    public <T> TableField $(Getter<T> getter) {
        return this.$(getter, 1);
    }

    public <T> TableField $(Getter<T> getter, int storey) {
        return this.$().field((Getter)getter, storey);
    }

    public Table $(Class entityType) {
        return this.$(entityType, 1);
    }

    public Table $(Class entityType, int storey) {
        return this.$().table(entityType, storey);
    }

    public TableField $(Class entityType, String fieldName) {
        return this.$(entityType, fieldName, 1);
    }

    public TableField $(Class entityType, String fieldName, int storey) {
        return this.$().field(entityType, fieldName, storey);
    }

    protected <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> DATASET_FIELD $(IDataset<DATASET, DATASET_FIELD> dataset, String columnName) {
        return this.$().field(dataset, columnName);
    }

    protected <E, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> DATASET_FIELD $(IDataset<DATASET, DATASET_FIELD> dataset, Getter<E> getter) {
        return this.$().field(dataset, getter);
    }

    public <T> SELF fetchFilter(Getter<T> getter, Consumer<Where> where) {
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(getter);
        String key = lambdaFieldInfo.getType().getName() + "." + lambdaFieldInfo.getName();
        if (Objects.isNull(this.fetchFilters)) {
            this.fetchFilters = new HashMap<String, Consumer<Where>>();
        }
        this.fetchFilters.put(key, where);
        return (SELF)this;
    }

    public <T> SELF fetchEnable(Getter<T> getter, Boolean enable) {
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(getter);
        String key = lambdaFieldInfo.getType().getName() + "." + lambdaFieldInfo.getName();
        if (Objects.isNull(this.fetchEnables)) {
            this.fetchEnables = new HashMap<String, Boolean>();
        }
        this.fetchEnables.put(key, enable);
        return (SELF)this;
    }

    public Map<String, Consumer<Where>> getFetchFilters() {
        return this.fetchFilters;
    }

    public void setFetchFilters(Map<String, Consumer<Where>> fetchFilters) {
        if (Objects.nonNull(this.fetchFilters)) {
            throw new RuntimeException("Can't call setFetchFilters when the this.fetchFilters has value");
        }
        this.fetchFilters = fetchFilters;
    }

    public Map<String, Boolean> getFetchEnables() {
        return this.fetchEnables;
    }

    public void setFetchEnables(Map<String, Boolean> fetchEnables) {
        if (Objects.nonNull(this.fetchEnables)) {
            throw new RuntimeException("Can't call fetchEnables when the this.fetchEnables has value");
        }
        this.fetchEnables = fetchEnables;
    }

    @Override
    protected void initCmdSorts(Map<Class<? extends Cmd>, Integer> cmdSorts) {
        int i = 0;
        cmdSorts.put(Withs.class, i += 10);
        cmdSorts.put(Select.class, i += 10);
        cmdSorts.put(From.class, i += 10);
        cmdSorts.put(Joins.class, i += 10);
        cmdSorts.put(Where.class, i += 10);
        cmdSorts.put(GroupBy.class, i += 10);
        cmdSorts.put(Having.class, i += 10);
        cmdSorts.put(OrderBy.class, i += 10);
        cmdSorts.put(Limit.class, i += 10);
        cmdSorts.put(ForUpdate.class, i += 10);
        cmdSorts.put(Unions.class, i += 10);
        cmdSorts.put(UnionsCmdLists.class, i += 10);
    }

    public With $with(IWithQuery withQuery) {
        if (Objects.isNull(this.withs)) {
            this.withs = new Withs();
            this.append((Cmd)this.withs);
        }
        With with = new With(withQuery);
        this.withs.add((IWith)with);
        return with;
    }

    public Select $select() {
        if (this.select == null) {
            this.select = new Select();
            this.append((Cmd)this.select);
        }
        return this.select;
    }

    public SELF selectCount1() {
        this.select(new Count1());
        return (SELF)this;
    }

    public SELF selectCountAll() {
        this.select(new CountAll());
        return (SELF)this;
    }

    public SELF selectCount1(Consumer<ICount1<?>> consumer) {
        Count1 count = new Count1();
        consumer.accept(count);
        this.select(count);
        return (SELF)this;
    }

    public SELF selectCountAll(Consumer<ICountAll<?>> consumer) {
        CountAll count = new CountAll();
        consumer.accept(count);
        this.select(count);
        return (SELF)this;
    }

    public <T> SELF select(Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.select((Cmd)((CmdFactory)this.$).field((Getter)column, storey)));
        }
        return (SELF)((AbstractQuery)this.select(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public SELF select(GetterField[] getterFields, Function<TableField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.select(((CmdFactory)this.$).fields(getterFields)));
        }
        return (SELF)((AbstractQuery)this.select(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public <T> SELF select(int storey, Getter<T> ... columns) {
        return (SELF)((AbstractQuery)this.select(((CmdFactory)this.$).fields(storey, columns)));
    }

    public SELF select(String columnName) {
        return (SELF)((AbstractQuery)this.select(Methods.column(columnName)));
    }

    public SELF select(String columnName, Function<IDatasetField, Cmd> f) {
        return (SELF)((AbstractQuery)this.select(f.apply(Methods.column(columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.select(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.select((Cmd[])this.getDatasetFields(dataset, (IColumnField[])getterFields)));
        }
        return (SELF)((AbstractQuery)this.select(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, String columnName) {
        return (SELF)((AbstractQuery)this.select((Cmd)this.$(dataset, columnName)));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.select(f.apply(this.$(dataset, column))));
    }

    public From $from(IDataset table) {
        if (this.from == null) {
            this.from = new From();
            this.append((Cmd)this.from);
        }
        this.from.append(table);
        this.getSQLListeners().stream().forEach(item -> item.onFrom((Object)this, table));
        return this.from;
    }

    public SELF from(Class entity, int storey, Consumer<Table> consumer) {
        ITable table = ((CmdFactory)this.$).table(entity, storey);
        this.from((IDataset)table);
        if (Objects.nonNull(consumer)) {
            consumer.accept((Table)table);
        }
        return (SELF)this;
    }

    public Join $join(JoinMode mode, IDataset<?, ?> mainTable, IDataset<?, ?> secondTable, Consumer<On> onConsumer) {
        Join join = new Join(mode, mainTable, secondTable, joinDataset -> new On(this.conditionFactory, (Join)joinDataset));
        if (Objects.isNull(this.joins)) {
            this.joins = new Joins();
            this.append((Cmd)this.joins);
        }
        this.joins.add((IJoin)join);
        if (Objects.nonNull(onConsumer)) {
            onConsumer.accept(join.getOn());
        }
        this.getSQLListeners().stream().forEach(item -> item.onJoin((Object)this, mode, mainTable, secondTable, (IOn)join.getOn()));
        return join;
    }

    public SELF join(JoinMode mode, Class<?> mainTable, int mainTableStorey, Class<?> secondTable, int secondTableStorey, Consumer<On> consumer) {
        return this.join(mode, (IDataset<?, ?>)((CmdFactory)this.$).table((Class)mainTable, mainTableStorey), (IDataset<?, ?>)((CmdFactory)this.$).table((Class)secondTable, secondTableStorey), consumer);
    }

    public SELF join(JoinMode mode, Class<?> mainTable, int mainTableStorey, IDataset<?, ?> secondTable, Consumer<On> consumer) {
        return this.join(mode, (IDataset<?, ?>)((CmdFactory)this.$).table((Class)mainTable, mainTableStorey), secondTable, consumer);
    }

    public Where $where() {
        if (this.where == null) {
            this.where = new Where(this.conditionFactory);
            this.append((Cmd)this.where);
        }
        return this.where;
    }

    public <T> SELF and(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().and(column, storey, f);
        return (SELF)this;
    }

    public <T> SELF or(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().or(column, storey, f);
        return (SELF)this;
    }

    public SELF join(JoinMode mode, IDataset<?, ?> mainTable, IDataset<?, ?> secondTable, Consumer<On> consumer) {
        this.$join(mode, (IDataset)mainTable, (IDataset)secondTable, (Consumer)consumer);
        return (SELF)this;
    }

    public GroupBy $groupBy() {
        if (this.groupBy == null) {
            this.groupBy = new GroupBy();
            this.append((Cmd)this.groupBy);
        }
        return this.groupBy;
    }

    public <T> SELF groupBy(Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.groupBy((Cmd)((CmdFactory)this.$).field((Getter)column, storey)));
        }
        return (SELF)((AbstractQuery)this.groupBy(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public SELF groupBy(GetterField[] getterFields, Function<TableField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.groupBy(((CmdFactory)this.$).fields(getterFields)));
        }
        return (SELF)((AbstractQuery)this.groupBy(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public <T> SELF groupBy(int storey, Getter<T> ... columns) {
        return (SELF)((AbstractQuery)this.groupBy(((CmdFactory)this.$).fields(storey, columns)));
    }

    public SELF groupBy(String columnName) {
        return (SELF)((AbstractQuery)this.groupBy(Methods.column(columnName)));
    }

    public SELF groupBy(String columnName, Function<IDatasetField, Cmd> f) {
        return (SELF)((AbstractQuery)this.groupBy(f.apply(Methods.column(columnName))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column) {
        return (SELF)((AbstractQuery)this.groupBy((Cmd)this.$(dataset, column)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.groupBy(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.groupBy((Cmd[])this.getDatasetFields(dataset, (IColumnField[])getterFields)));
        }
        return (SELF)((AbstractQuery)this.groupBy(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.groupBy(f.apply(this.$(dataset, column))));
    }

    public Having $having() {
        if (this.having == null) {
            this.having = new Having((CmdFactory)this.$);
            this.append((Cmd)this.having);
        }
        return this.having;
    }

    public <T> SELF havingAnd(boolean when, Getter<T> column, int storey, Function<TableField, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public <T> SELF havingOr(boolean when, Getter<T> column, int storey, Function<TableField, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(this.$(dataset, column))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply(this.$(dataset, column))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        return (SELF)((AbstractQuery)this.havingOr(f.apply(this.$(dataset, columnName))));
    }

    public SELF havingAnd(boolean when, GetterField[] getterFields, Function<TableField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public SELF havingOr(boolean when, GetterField[] getterFields, Function<TableField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    private <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> IDatasetField[] getDatasetFields(IDataset<DATASET, DATASET_FIELD> dataset, IColumnField ... columnFields) {
        IDatasetField[] datasetFields = new IDatasetField[columnFields.length];
        for (int i = 0; i < columnFields.length; ++i) {
            IColumnField columnField = columnFields[i];
            if (columnField instanceof ColumnField) {
                datasetFields[i] = this.$(dataset, ((ColumnField)columnField).getColumnName());
                continue;
            }
            if (columnField instanceof GetterField) {
                datasetFields[i] = this.$(dataset, ((GetterField)columnField).getGetter());
                continue;
            }
            throw new RuntimeException("Not Supported");
        }
        return datasetFields;
    }

    private <R, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> R apply(IDataset<DATASET, DATASET_FIELD> dataset, Function<IDatasetField[], R> f, IColumnField ... columnFields) {
        return f.apply(this.getDatasetFields(dataset, columnFields));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public OrderBy $orderBy() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
            this.append((Cmd)this.orderBy);
        }
        return this.orderBy;
    }

    public IOrderByDirection ascOrderByDirection() {
        return OrderByDirection.ASC;
    }

    public IOrderByDirection descOrderByDirection() {
        return OrderByDirection.DESC;
    }

    public ForUpdate $forUpdate() {
        if (this.forUpdate == null) {
            this.forUpdate = new ForUpdate();
            this.append((Cmd)this.forUpdate);
        }
        return this.forUpdate;
    }

    public Limit $limit() {
        if (this.limit == null) {
            this.limit = new Limit(0, 0);
            this.append((Cmd)this.limit);
        }
        return this.limit;
    }

    public <T> SELF orderBy(IOrderByDirection orderByDirection, Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)((CmdFactory)this.$).field((Getter)column, storey)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public SELF orderBy(IOrderByDirection orderByDirection, GetterField[] getterFields, Function<TableField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, ((CmdFactory)this.$).fields(getterFields)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public <T> SELF orderBy(IOrderByDirection orderByDirection, int storey, Getter<T> ... columns) {
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, ((CmdFactory)this.$).fields(storey, columns)));
    }

    public SELF orderBy(IOrderByDirection orderByDirection, String columnName) {
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, Methods.column(columnName)));
    }

    public SELF orderBy(IOrderByDirection orderByDirection, String columnName, Function<IDatasetField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, Methods.column(columnName)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(Methods.column(columnName))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, Getter<T> column, Function<DATASET_FIELD, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)this.$(dataset, column)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(this.$(dataset, column))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, String columnName, Function<DATASET_FIELD, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)this.$(dataset, columnName)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, GetterField[] getterFields, Function<IDatasetField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd[])this.getDatasetFields(dataset, (IColumnField[])getterFields)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, String columnName) {
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)this.$(dataset, columnName)));
    }

    public Unions $unions() {
        if (this.unions == null) {
            this.unions = new Unions();
            this.cmds.add(this.unions);
        }
        return this.unions;
    }

    public SELF union(IQuery unionQuery) {
        this.$unions().add((IUnion)new Union(unionQuery));
        return (SELF)this;
    }

    public SELF unionAll(IQuery unionQuery) {
        this.$unions().add((IUnion)new Union(SqlConst.UNION_ALL, unionQuery));
        return (SELF)this;
    }

    public Select getSelect() {
        return this.select;
    }

    public From getFrom() {
        return this.from;
    }

    public Joins getJoins() {
        return this.joins;
    }

    public Where getWhere() {
        return this.where;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public Having getHaving() {
        return this.having;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean removeLimit() {
        if (Objects.isNull(this.getLimit())) {
            return false;
        }
        return this.cmds().remove(this.getLimit());
    }

    public Unions getUnions() {
        return this.unions;
    }

    public ForUpdate getForUpdate() {
        return this.forUpdate;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        this.selectorExecute(context.getDbType());
        if (this.limit == null) {
            List<Cmd> cmdList = this.cmds();
            if (cmdList == null || cmdList.isEmpty()) {
                return sqlBuilder;
            }
            List sortedCmds = this.sortedCmds();
            if (sortedCmds == null || sortedCmds.isEmpty()) {
                return sqlBuilder;
            }
            return CmdUtils.join((Cmd)this, (Cmd)this, (SqlBuilderContext)context, (StringBuilder)sqlBuilder, (List)sortedCmds);
        }
        return QuerySQLUtil.buildQuerySQL(context, module, parent, this, sqlBuilder, this.sortedCmds());
    }
}

