/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.condition;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.LikeMode;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.condition.AbstractLike;
import db.sql.api.impl.cmd.condition.NotILike;
import db.sql.api.impl.tookit.SqlConst;

public abstract class AbstractILike<T extends AbstractILike<T>>
extends AbstractLike<T> {
    public AbstractILike(char[] operator, LikeMode mode, Cmd key, Cmd value) {
        super(operator, mode, key, value);
    }

    boolean notSupport(DbType dbType) {
        switch (dbType) {
            case PGSQL: 
            case OPEN_GAUSS: 
            case H2: 
            case KING_BASE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public StringBuilder conditionSql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (this.notSupport(context.getDbType())) {
            char[] cArray = this.operator = this instanceof NotILike ? SqlConst.NOT_LIKE : SqlConst.LIKE;
        }
        if (context.getDbType() != DbType.MYSQL && context.getDbType() != DbType.MARIA_DB && context.getDbType() != DbType.SQL_SERVER) {
            this.field = Methods.upper(this.field);
            this.value = Methods.upper(this.value);
        }
        return super.conditionSql(module, parent, context, sqlBuilder);
    }
}

