/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.From;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.LambdaUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Table
implements ITable<Table, TableField>,
IDataset<Table, TableField> {
    protected String alias;
    protected String prefix;
    protected String name;
    protected String[] ids;
    protected Set<String> idsSet;
    protected String forceIndex;

    public Table(String name) {
        this.name = name;
    }

    public Table(String name, String alias) {
        this(name);
        this.alias = alias;
    }

    public Table(String name, String[] ids, String alias) {
        this(name);
        this.alias = alias;
        this.ids = ids;
    }

    public TableField $(String name) {
        return new TableField(this, name);
    }

    public String getName() {
        return this.name;
    }

    public Table setName(String name) {
        this.name = name;
        return this;
    }

    public String getName(DbType dbType) {
        return dbType.wrap(this.name);
    }

    public String getAlias() {
        return this.alias;
    }

    public Table setAlias(String alias) {
        return this.as(alias);
    }

    public Table as(String alias) {
        this.alias = alias;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Table setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(this.getName(context.getDbType()));
        if (this.getAlias() != null) {
            sqlBuilder.append(SqlConst.BLANK).append(this.getAlias());
        }
        if ((parent instanceof From || parent instanceof Join) && Objects.nonNull(this.forceIndex) && !"".equals(this.forceIndex)) {
            sqlBuilder.append(SqlConst.FORCE_INDEX(context.getDbType(), this.forceIndex));
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return false;
    }

    public Table forceIndex(String forceIndex) {
        this.forceIndex = forceIndex;
        return this;
    }

    public <E> TableField $(Getter<E> column) {
        return this.$(LambdaUtil.getName(column));
    }

    public String[] getIds() {
        return this.ids;
    }

    public boolean isId(String column) {
        if (this.ids == null || this.ids.length == 0) {
            return false;
        }
        if (this.idsSet == null) {
            this.idsSet = new HashSet<String>();
            for (String id : this.ids) {
                this.idsSet.add(id);
            }
        }
        return this.idsSet.contains(column);
    }
}

