/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IConflictUpdate;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.ConflictUpdateTableField;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.AbstractInsert;
import db.sql.api.impl.cmd.struct.insert.InsertFields;
import db.sql.api.impl.cmd.struct.update.UpdateSets;
import db.sql.api.tookit.CmdUtils;
import java.util.ArrayList;
import java.util.List;

public class ConflictUpdate<T>
implements IConflictUpdate<T>,
Cmd {
    private final CmdFactory cmdFactory;
    private boolean overwriteAll;
    private List<TableField> customizeSetValueFields;
    private List<TableField> overwriteFields;
    private List<TableField> ignoreFields;
    private UpdateSets updateSets;
    private boolean execute;

    public ConflictUpdate(CmdFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    public IConflictUpdate<T> set(Getter<T> field, Object value) {
        if (this.customizeSetValueFields == null) {
            this.customizeSetValueFields = new ArrayList<TableField>();
        }
        if (this.updateSets == null) {
            this.updateSets = new UpdateSets();
        }
        TableField tableField = (TableField)this.cmdFactory.field(field);
        this.updateSets.set(tableField, Methods.cmd(value));
        this.customizeSetValueFields.add(tableField);
        return this;
    }

    public IConflictUpdate<T> overwrite(Getter<T> ... fields) {
        for (Getter<T> field : fields) {
            TableField tableField = (TableField)this.cmdFactory.field(field);
            if (this.overwriteFields == null) {
                this.overwriteFields = new ArrayList<TableField>();
            }
            this.overwriteFields.add(tableField);
        }
        return this;
    }

    public IConflictUpdate<T> overwriteAll() {
        this.overwriteAll = true;
        return this;
    }

    public IConflictUpdate<T> ignore(Getter<T> ... fields) {
        for (Getter<T> field : fields) {
            TableField tableField = (TableField)this.cmdFactory.field(field);
            if (this.ignoreFields == null) {
                this.ignoreFields = new ArrayList<TableField>();
            }
            this.ignoreFields.add(tableField);
        }
        return this;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (!this.execute) {
            this.execute = true;
            if (this.updateSets == null) {
                this.updateSets = new UpdateSets();
            }
            if (this.overwriteAll) {
                AbstractInsert insert = (AbstractInsert)module;
                InsertFields insertFields = insert.getInsertFields();
                insertFields.getFields().stream().filter(item -> !item.isId()).forEach(i -> {
                    if (this.ignoreFields != null && this.ignoreFields.contains(i)) {
                        return;
                    }
                    if (this.customizeSetValueFields != null && this.customizeSetValueFields.contains(i)) {
                        return;
                    }
                    this.updateSets.set((TableField)i, new ConflictUpdateTableField((TableField)i));
                });
            } else if (this.overwriteFields != null) {
                this.overwriteFields.forEach(i -> {
                    if (this.ignoreFields != null && this.ignoreFields.contains(i)) {
                        return;
                    }
                    if (this.customizeSetValueFields != null && this.customizeSetValueFields.contains(i)) {
                        return;
                    }
                    this.updateSets.set((TableField)i, new ConflictUpdateTableField((TableField)i));
                });
            } else if (this.customizeSetValueFields == null) {
                throw new IllegalStateException("conflict update not set");
            }
        }
        if (this.updateSets == null) {
            throw new IllegalStateException("conflict update not set");
        }
        return this.updateSets.sql(module, this, context, sqlBuilder);
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, (Cmd)this.updateSets);
    }
}

