/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IConflictAction;
import db.sql.api.cmd.basic.IConflictUpdate;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.basic.ConflictUpdate;
import db.sql.api.tookit.CmdUtils;
import java.util.function.Consumer;

public class ConflictAction<T>
implements IConflictAction<T>,
Cmd {
    private final CmdFactory cmdFactory;
    private ConflictUpdate<T> conflictUpdate;
    private boolean doNothing;

    public ConflictAction(CmdFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    public IConflictUpdate<T> getConflictUpdate() {
        return this.conflictUpdate;
    }

    public void doNothing() {
        this.doNothing = true;
    }

    public void doUpdate(Consumer<IConflictUpdate<T>> consumer) {
        if (this.conflictUpdate == null) {
            this.conflictUpdate = new ConflictUpdate(this.cmdFactory);
        }
        consumer.accept(this.conflictUpdate);
    }

    public boolean isDoNothing() {
        return this.doNothing && this.conflictUpdate == null;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (!this.doNothing && this.conflictUpdate == null) {
            throw new IllegalStateException("conflict action not set");
        }
        if (this.conflictUpdate == null) {
            if (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.KING_BASE || context.getDbType() == DbType.SQLITE) {
                sqlBuilder.append(" DO NOTHING");
            } else if (context.getDbType() == DbType.OPEN_GAUSS) {
                sqlBuilder.append(" UPDATE NOTHING");
            }
        } else {
            if (context.getDbType() == DbType.PGSQL || context.getDbType() == DbType.KING_BASE || context.getDbType() == DbType.SQLITE) {
                sqlBuilder.append(" DO UPDATE");
            } else if (context.getDbType() == DbType.OPEN_GAUSS) {
                sqlBuilder.append(" UPDATE");
            }
            this.conflictUpdate.sql(module, this, context, sqlBuilder);
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.conflictUpdate);
    }
}

